/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;

public class NoCloseExecutor
implements CloseableExecutorService {
    protected final ExecutorService executor;
    protected final CloseFuture closeFuture;

    public NoCloseExecutor(ExecutorService executorService) {
        this.executor = executorService;
        this.closeFuture = new DefaultCloseFuture(null, null);
    }

    public Future submit(Callable callable) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(callable);
    }

    public Future submit(Runnable runnable, Object object) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(runnable, object);
    }

    public Future submit(Runnable runnable) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.submit(runnable);
    }

    public List invokeAll(Collection collection) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAll(collection);
    }

    public List invokeAll(Collection collection, long l2, TimeUnit timeUnit) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAll(collection, l2, timeUnit);
    }

    public Object invokeAny(Collection collection) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAny(collection);
    }

    public Object invokeAny(Collection collection, long l2, TimeUnit timeUnit) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        return this.executor.invokeAny(collection, l2, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        ValidateUtils.checkState(!this.isShutdown(), "Executor has been shut down");
        this.executor.execute(runnable);
    }

    @Override
    public void shutdown() {
        this.close(true);
    }

    public List shutdownNow() {
        this.close(true);
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.isClosed();
    }

    @Override
    public boolean isTerminated() {
        return this.isClosed();
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        try {
            return this.closeFuture.await(l2, timeUnit);
        }
        catch (IOException iOException) {
            throw (InterruptedException)new InterruptedException().initCause(iOException);
        }
    }

    @Override
    public CloseFuture close(boolean bl2) {
        this.closeFuture.setClosed();
        return this.closeFuture;
    }

    @Override
    public void addCloseFutureListener(SshFutureListener sshFutureListener) {
        this.closeFuture.addListener(sshFutureListener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener sshFutureListener) {
        this.closeFuture.removeListener(sshFutureListener);
    }

    @Override
    public boolean isClosed() {
        return this.closeFuture.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.isClosed();
    }
}

