/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.Closeable;

public interface CloseableExecutorService
extends ExecutorService,
Closeable {
    default public boolean awaitTermination(Duration duration) {
        Objects.requireNonNull(duration, "No timeout specified");
        return this.awaitTermination(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    default public void close() {
        try {
            Closeable.super.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

