/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderUtils;

public class OpenSSHEd25519PrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder {
    public static final OpenSSHEd25519PrivateKeyEntryDecoder INSTANCE = new OpenSSHEd25519PrivateKeyEntryDecoder();
    private static final int PK_SIZE = 32;
    private static final int SK_SIZE = 32;
    private static final int KEYPAIR_SIZE = 64;

    public OpenSSHEd25519PrivateKeyEntryDecoder() {
        super(EdDSAPublicKey.class, EdDSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-ed25519")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdDSAPrivateKey decodePrivateKey(SessionContext sessionContext, String string, FilePasswordProvider filePasswordProvider, InputStream inputStream) {
        if (!"ssh-ed25519".equals(string)) {
            throw new InvalidKeyException("Unsupported key type: " + string);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        byte[] byArray = GenericUtils.EMPTY_BYTE_ARRAY;
        byte[] byArray2 = GenericUtils.EMPTY_BYTE_ARRAY;
        try {
            EdDSANamedCurveSpec edDSANamedCurveSpec;
            byArray = KeyEntryResolver.readRLEBytes(inputStream, 64);
            byArray2 = KeyEntryResolver.readRLEBytes(inputStream, 128);
            if (byArray.length != 32) {
                throw new InvalidKeyException(String.format(Locale.ENGLISH, "Unexpected pk size: %s (expected %s)", byArray.length, 32));
            }
            if (byArray2.length != 64) {
                throw new InvalidKeyException(String.format(Locale.ENGLISH, "Unexpected keypair size: %s (expected %s)", byArray2.length, 64));
            }
            if (!Arrays.equals(byArray, Arrays.copyOfRange(byArray2, 32, 64))) {
                throw new InvalidKeyException("Keypair did not contain the public key.");
            }
            byte[] byArray3 = Arrays.copyOf(byArray2, 32);
            EdDSAPrivateKey edDSAPrivateKey = (EdDSAPrivateKey)this.generatePrivateKey(new EdDSAPrivateKeySpec(byArray3, edDSANamedCurveSpec = EdDSANamedCurveTable.getByName("Ed25519")));
            if (!Arrays.equals(edDSAPrivateKey.getAbyte(), byArray)) {
                throw new InvalidKeyException("The provided pk does NOT match the computed pk for the given sk.");
            }
            EdDSAPrivateKey edDSAPrivateKey2 = edDSAPrivateKey;
            return edDSAPrivateKey2;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
            Arrays.fill(byArray2, (byte)0);
        }
    }

    public String encodePrivateKey(SecureByteArrayOutputStream secureByteArrayOutputStream, EdDSAPrivateKey edDSAPrivateKey, EdDSAPublicKey edDSAPublicKey) {
        Objects.requireNonNull(edDSAPrivateKey, "No private key provided");
        byte[] byArray = edDSAPrivateKey.getSeed();
        byte[] byArray2 = edDSAPrivateKey.getAbyte();
        Objects.requireNonNull(byArray, "No seed");
        byte[] byArray3 = new byte[64];
        System.arraycopy(byArray, 0, byArray3, 0, 32);
        System.arraycopy(byArray2, 0, byArray3, 32, 32);
        KeyEntryResolver.writeRLEBytes((OutputStream)secureByteArrayOutputStream, byArray2);
        KeyEntryResolver.writeRLEBytes((OutputStream)secureByteArrayOutputStream, byArray3);
        return "ssh-ed25519";
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    public EdDSAPublicKey recoverPublicKey(EdDSAPrivateKey edDSAPrivateKey) {
        return EdDSASecurityProviderUtils.recoverEDDSAPublicKey(edDSAPrivateKey);
    }

    public EdDSAPublicKey clonePublicKey(EdDSAPublicKey edDSAPublicKey) {
        if (edDSAPublicKey == null) {
            return null;
        }
        return (EdDSAPublicKey)this.generatePublicKey(new EdDSAPublicKeySpec(edDSAPublicKey.getA(), edDSAPublicKey.getParams()));
    }

    public EdDSAPrivateKey clonePrivateKey(EdDSAPrivateKey edDSAPrivateKey) {
        if (edDSAPrivateKey == null) {
            return null;
        }
        return (EdDSAPrivateKey)this.generatePrivateKey(new EdDSAPrivateKeySpec(edDSAPrivateKey.getSeed(), edDSAPrivateKey.getParams()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        return SecurityUtils.getKeyPairGenerator("EdDSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        return SecurityUtils.getKeyFactory("EdDSA");
    }
}

