/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.Ed25519PublicKeyDecoder;
import org.apache.sshd.common.util.security.eddsa.OpenSSHEd25519PrivateKeyEntryDecoder;
import org.apache.sshd.common.util.security.eddsa.SignatureEd25519;

public final class EdDSASecurityProviderUtils {
    public static final String CURVE_ED25519_SHA512 = "Ed25519";
    public static final int KEY_SIZE = 256;

    private EdDSASecurityProviderUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Class getEDDSAPublicKeyType() {
        return EdDSAPublicKey.class;
    }

    public static Class getEDDSAPrivateKeyType() {
        return EdDSAPrivateKey.class;
    }

    public static boolean isEDDSAKey(Key key) {
        return EdDSASecurityProviderUtils.getEDDSAKeySize(key) == 256;
    }

    public static int getEDDSAKeySize(Key key) {
        return SecurityUtils.isEDDSACurveSupported() && key instanceof EdDSAKey ? 256 : -1;
    }

    public static boolean compareEDDSAPPublicKeys(PublicKey publicKey, PublicKey publicKey2) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            return false;
        }
        if (publicKey instanceof EdDSAPublicKey && publicKey2 instanceof EdDSAPublicKey) {
            if (publicKey.equals(publicKey2)) {
                return true;
            }
            EdDSAPublicKey edDSAPublicKey = (EdDSAPublicKey)publicKey;
            EdDSAPublicKey edDSAPublicKey2 = (EdDSAPublicKey)publicKey2;
            return Arrays.equals(edDSAPublicKey.getAbyte(), edDSAPublicKey2.getAbyte()) && EdDSASecurityProviderUtils.compareEDDSAKeyParams(edDSAPublicKey.getParams(), edDSAPublicKey2.getParams());
        }
        return false;
    }

    public static boolean isEDDSASignatureAlgorithm(String string) {
        return "NONEwithEdDSA".equalsIgnoreCase(string);
    }

    public static EdDSAPublicKey recoverEDDSAPublicKey(PrivateKey privateKey) {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        if (!(privateKey instanceof EdDSAPrivateKey)) {
            throw new InvalidKeyException("Private key is not EdDSA");
        }
        EdDSAPrivateKey edDSAPrivateKey = (EdDSAPrivateKey)privateKey;
        EdDSAPublicKeySpec edDSAPublicKeySpec = new EdDSAPublicKeySpec(edDSAPrivateKey.getAbyte(), edDSAPrivateKey.getParams());
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EdDSA");
        return (EdDSAPublicKey)EdDSAPublicKey.class.cast(keyFactory.generatePublic(edDSAPublicKeySpec));
    }

    public static Signature getEDDSASignature() {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        return new SignatureEd25519();
    }

    public static boolean isEDDSAKeyFactoryAlgorithm(String string) {
        return "EdDSA".equalsIgnoreCase(string);
    }

    public static boolean isEDDSAKeyPairGeneratorAlgorithm(String string) {
        return "EdDSA".equalsIgnoreCase(string);
    }

    public static PublicKeyEntryDecoder getEDDSAPublicKeyEntryDecoder() {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        return Ed25519PublicKeyDecoder.INSTANCE;
    }

    public static PrivateKeyEntryDecoder getOpenSSHEDDSAPrivateKeyEntryDecoder() {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        return OpenSSHEd25519PrivateKeyEntryDecoder.INSTANCE;
    }

    public static boolean compareEDDSAPrivateKeys(PrivateKey privateKey, PrivateKey privateKey2) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            return false;
        }
        if (privateKey instanceof EdDSAPrivateKey && privateKey2 instanceof EdDSAPrivateKey) {
            if (privateKey.equals(privateKey2)) {
                return true;
            }
            EdDSAPrivateKey edDSAPrivateKey = (EdDSAPrivateKey)privateKey;
            EdDSAPrivateKey edDSAPrivateKey2 = (EdDSAPrivateKey)privateKey2;
            return Arrays.equals(edDSAPrivateKey.getSeed(), edDSAPrivateKey2.getSeed()) && EdDSASecurityProviderUtils.compareEDDSAKeyParams(edDSAPrivateKey.getParams(), edDSAPrivateKey2.getParams());
        }
        return false;
    }

    public static boolean compareEDDSAKeyParams(EdDSAParameterSpec edDSAParameterSpec, EdDSAParameterSpec edDSAParameterSpec2) {
        if (Objects.equals(edDSAParameterSpec, edDSAParameterSpec2)) {
            return true;
        }
        if (edDSAParameterSpec == null || edDSAParameterSpec2 == null) {
            return false;
        }
        return Objects.equals(edDSAParameterSpec.getHashAlgorithm(), edDSAParameterSpec2.getHashAlgorithm()) && Objects.equals(edDSAParameterSpec.getCurve(), edDSAParameterSpec2.getCurve()) && Objects.equals(edDSAParameterSpec.getB(), edDSAParameterSpec2.getB());
    }

    public static PublicKey generateEDDSAPublicKey(byte[] byArray) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA not supported");
        }
        EdDSANamedCurveSpec edDSANamedCurveSpec = EdDSANamedCurveTable.getByName(CURVE_ED25519_SHA512);
        EdDSAPublicKeySpec edDSAPublicKeySpec = new EdDSAPublicKeySpec(byArray, (EdDSAParameterSpec)edDSANamedCurveSpec);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EdDSA");
        return keyFactory.generatePublic(edDSAPublicKeySpec);
    }

    public static PrivateKey generateEDDSAPrivateKey(byte[] byArray) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA not supported");
        }
        EdDSANamedCurveSpec edDSANamedCurveSpec = EdDSANamedCurveTable.getByName(CURVE_ED25519_SHA512);
        EdDSAPrivateKeySpec edDSAPrivateKeySpec = new EdDSAPrivateKeySpec(byArray, edDSANamedCurveSpec);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EdDSA");
        return keyFactory.generatePrivate(edDSAPrivateKeySpec);
    }

    public static Buffer putRawEDDSAPublicKey(Buffer buffer, PublicKey publicKey) {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        EdDSAPublicKey edDSAPublicKey = (EdDSAPublicKey)ValidateUtils.checkInstanceOf((Object)publicKey, EdDSAPublicKey.class, "Not an EDDSA public key: %s", (Object)publicKey);
        byte[] byArray = Ed25519PublicKeyDecoder.getSeedValue(edDSAPublicKey);
        ValidateUtils.checkNotNull((Object)byArray, "No seed extracted from key: %s", (Object)edDSAPublicKey.getA());
        buffer.putBytes(byArray);
        return buffer;
    }

    public static Buffer putEDDSAKeyPair(Buffer buffer, PublicKey publicKey, PrivateKey privateKey) {
        ValidateUtils.checkTrue(SecurityUtils.isEDDSACurveSupported(), "EdDSA not supported");
        ValidateUtils.checkInstanceOf((Object)publicKey, EdDSAPublicKey.class, "Not an EDDSA public key: %s", (Object)publicKey);
        ValidateUtils.checkInstanceOf((Object)privateKey, EdDSAPrivateKey.class, "Not an EDDSA private key: %s", (Object)privateKey);
        throw new UnsupportedOperationException("Full SSHD-440 implementation N/A");
    }
}

