/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Signature;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class EdDSASecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "net.i2p.crypto.eddsa.EdDSASecurityProvider";
    private final AtomicReference supportHolder = new AtomicReference<Object>(null);

    public EdDSASecurityProviderRegistrar() {
        super("EdDSA");
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return this.getBooleanProperty("org.apache.sshd.eddsaSupport", true);
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(PROVIDER_CLASS);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Throwable throwable = ExceptionUtils.peelException(reflectiveOperationException);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", new Object[]{this.getName(), throwable.getClass().getSimpleName(), PROVIDER_CLASS, throwable.getMessage()});
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(throwable);
        }
    }

    @Override
    public boolean isSecurityEntitySupported(Class clazz, String string) {
        if (!this.isSupported()) {
            return false;
        }
        if (KeyPairGenerator.class.isAssignableFrom(clazz) || KeyFactory.class.isAssignableFrom(clazz)) {
            return Objects.compare(string, this.getName(), String.CASE_INSENSITIVE_ORDER) == 0;
        }
        if (Signature.class.isAssignableFrom(clazz)) {
            return Objects.compare("NONEwithEdDSA", string, String.CASE_INSENSITIVE_ORDER) == 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean bl2;
        AtomicReference atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            bl2 = (Boolean)this.supportHolder.get();
            if (bl2 != null) {
                return bl2;
            }
            Class clazz = ThreadUtils.resolveDefaultClass(this.getClass(), "net.i2p.crypto.eddsa.EdDSAKey");
            bl2 = clazz != null;
            this.supportHolder.set(bl2);
        }
        return bl2;
    }
}

