/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class Ed25519PublicKeyDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final int MAX_ALLOWED_SEED_LEN = 1024;
    public static final Ed25519PublicKeyDecoder INSTANCE = new Ed25519PublicKeyDecoder();

    private Ed25519PublicKeyDecoder() {
        super(EdDSAPublicKey.class, EdDSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-ed25519")));
    }

    public EdDSAPublicKey clonePublicKey(EdDSAPublicKey edDSAPublicKey) {
        if (edDSAPublicKey == null) {
            return null;
        }
        return (EdDSAPublicKey)this.generatePublicKey(new EdDSAPublicKeySpec(edDSAPublicKey.getA(), edDSAPublicKey.getParams()));
    }

    public EdDSAPrivateKey clonePrivateKey(EdDSAPrivateKey edDSAPrivateKey) {
        if (edDSAPrivateKey == null) {
            return null;
        }
        return (EdDSAPrivateKey)this.generatePrivateKey(new EdDSAPrivateKeySpec(edDSAPrivateKey.getSeed(), edDSAPrivateKey.getParams()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        return SecurityUtils.getKeyPairGenerator("EdDSA");
    }

    public String encodePublicKey(OutputStream outputStream, EdDSAPublicKey edDSAPublicKey) {
        Objects.requireNonNull(edDSAPublicKey, "No public key provided");
        KeyEntryResolver.encodeString(outputStream, "ssh-ed25519");
        byte[] byArray = Ed25519PublicKeyDecoder.getSeedValue(edDSAPublicKey);
        KeyEntryResolver.writeRLEBytes(outputStream, byArray);
        return "ssh-ed25519";
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        return SecurityUtils.getKeyFactory("EdDSA");
    }

    @Override
    public EdDSAPublicKey decodePublicKey(SessionContext sessionContext, String string, InputStream inputStream, Map map) {
        byte[] byArray = KeyEntryResolver.readRLEBytes(inputStream, 1024);
        return (EdDSAPublicKey)EdDSAPublicKey.class.cast(SecurityUtils.generateEDDSAPublicKey(string, byArray));
    }

    public static byte[] getSeedValue(EdDSAPublicKey edDSAPublicKey) {
        return edDSAPublicKey == null ? null : edDSAPublicKey.getAbyte();
    }
}

