/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderUtils;

public class Ed25519PEMResourceKeyParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN EDDSA PRIVATE KEY";
    public static final String BEGIN_ED25519_MARKER = "BEGIN ED25519 PRIVATE KEY";
    public static final List BEGINNERS = GenericUtils.unmodifiableList("BEGIN EDDSA PRIVATE KEY", "BEGIN ED25519 PRIVATE KEY");
    public static final String END_MARKER = "END EDDSA PRIVATE KEY";
    public static final String END_ED25519_MARKER = "END ED25519 PRIVATE KEY";
    public static final List ENDERS = GenericUtils.unmodifiableList("END EDDSA PRIVATE KEY", "END ED25519 PRIVATE KEY");
    public static final String ED25519_OID = "1.3.101.112";
    public static final Ed25519PEMResourceKeyParser INSTANCE = new Ed25519PEMResourceKeyParser();

    public Ed25519PEMResourceKeyParser() {
        super("EdDSA", ED25519_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, InputStream inputStream, Map map) {
        KeyPair keyPair = Ed25519PEMResourceKeyParser.parseEd25519KeyPair(inputStream, false);
        return Collections.singletonList(keyPair);
    }

    public static KeyPair parseEd25519KeyPair(InputStream inputStream, boolean bl2) {
        try (DERParser dERParser = new DERParser(NoCloseInputStream.resolveInputStream(inputStream, bl2));){
            KeyPair keyPair = Ed25519PEMResourceKeyParser.parseEd25519KeyPair(dERParser);
            return keyPair;
        }
    }

    public static KeyPair parseEd25519KeyPair(DERParser dERParser) {
        List list;
        ASN1Object aSN1Object = dERParser.readObject();
        if (aSN1Object == null) {
            throw new StreamCorruptedException("Missing version value");
        }
        BigInteger bigInteger = aSN1Object.asInteger();
        if (!BigInteger.ZERO.equals(bigInteger)) {
            throw new StreamCorruptedException("Invalid version: " + bigInteger);
        }
        aSN1Object = dERParser.readObject();
        if (aSN1Object == null) {
            throw new StreamCorruptedException("Missing OID container");
        }
        ASN1Type aSN1Type = aSN1Object.getObjType();
        if (aSN1Type != ASN1Type.SEQUENCE) {
            throw new StreamCorruptedException("Unexpected OID object type: " + (Object)((Object)aSN1Type));
        }
        try (Object object = aSN1Object.createParser();){
            aSN1Object = ((DERParser)object).readObject();
            if (aSN1Object == null) {
                throw new StreamCorruptedException("Missing OID value");
            }
            list = aSN1Object.asOID();
        }
        object = GenericUtils.join((Iterable)list, '.');
        if (!ED25519_OID.equals(object)) {
            throw new StreamCorruptedException("Unsupported curve OID: " + (String)object);
        }
        aSN1Object = dERParser.readObject();
        if (aSN1Object == null) {
            throw new StreamCorruptedException("Missing key data");
        }
        return Ed25519PEMResourceKeyParser.decodeEd25519KeyPair(aSN1Object.getValue());
    }

    public static KeyPair decodeEd25519KeyPair(byte[] byArray) {
        EdDSAPrivateKey edDSAPrivateKey = Ed25519PEMResourceKeyParser.decodeEdDSAPrivateKey(byArray);
        EdDSAPublicKey edDSAPublicKey = EdDSASecurityProviderUtils.recoverEDDSAPublicKey(edDSAPrivateKey);
        return new KeyPair(edDSAPublicKey, edDSAPrivateKey);
    }

    public static EdDSAPrivateKey decodeEdDSAPrivateKey(byte[] byArray) {
        try (DERParser dERParser = new DERParser(byArray);){
            ASN1Object aSN1Object = dERParser.readObject();
            if (aSN1Object == null) {
                throw new StreamCorruptedException("Missing key data container");
            }
            ASN1Type aSN1Type = aSN1Object.getObjType();
            if (aSN1Type != ASN1Type.OCTET_STRING) {
                throw new StreamCorruptedException("Mismatched key data container type: " + (Object)((Object)aSN1Type));
            }
            EdDSAPrivateKey edDSAPrivateKey = Ed25519PEMResourceKeyParser.generateEdDSAPrivateKey(aSN1Object.getValue());
            return edDSAPrivateKey;
        }
    }

    public static EdDSAPrivateKey generateEdDSAPrivateKey(byte[] byArray) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        EdDSANamedCurveSpec edDSANamedCurveSpec = EdDSANamedCurveTable.getByName("Ed25519");
        EdDSAPrivateKeySpec edDSAPrivateKeySpec = new EdDSAPrivateKeySpec(byArray, edDSANamedCurveSpec);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EdDSA");
        return (EdDSAPrivateKey)EdDSAPrivateKey.class.cast(keyFactory.generatePrivate(edDSAPrivateKeySpec));
    }
}

