/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Signature;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class BouncyCastleSecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private final AtomicReference supportHolder = new AtomicReference<Object>(null);
    private final AtomicReference allSupportHolder = new AtomicReference();

    public BouncyCastleSecurityProviderRegistrar() {
        super("BC");
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return this.getBooleanProperty("org.apache.sshd.registerBouncyCastle", true);
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(PROVIDER_CLASS);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Throwable throwable = ExceptionUtils.peelException(reflectiveOperationException);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", new Object[]{this.getName(), throwable.getClass().getSimpleName(), PROVIDER_CLASS, throwable.getMessage()});
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(throwable);
        }
    }

    @Override
    public String getDefaultSecurityEntitySupportValue(Class clazz) {
        String string = (String)this.allSupportHolder.get();
        if (GenericUtils.length(string) > 0) {
            return string;
        }
        String string2 = this.getConfigurationPropertyName("supportAll");
        string = this.getStringProperty(string2, "all");
        if (GenericUtils.isEmpty(string)) {
            string = "none";
        }
        this.allSupportHolder.set(string);
        return string;
    }

    @Override
    public boolean isSecurityEntitySupported(Class clazz, String string) {
        if (!this.isSupported()) {
            return false;
        }
        if (KeyPairGenerator.class.isAssignableFrom(clazz) || KeyFactory.class.isAssignableFrom(clazz) ? Objects.compare(string, "EdDSA", String.CASE_INSENSITIVE_ORDER) == 0 : Signature.class.isAssignableFrom(clazz) && Objects.compare(string, "NONEwithEdDSA", String.CASE_INSENSITIVE_ORDER) == 0) {
            return false;
        }
        return super.isSecurityEntitySupported(clazz, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean bl2;
        AtomicReference atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            bl2 = (Boolean)this.supportHolder.get();
            if (bl2 != null) {
                return bl2;
            }
            Class clazz = ThreadUtils.resolveDefaultClass(this.getClass(), PROVIDER_CLASS);
            bl2 = clazz != null;
            this.supportHolder.set(bl2);
        }
        return bl2;
    }
}

