/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.security.SecureRandom;
import org.apache.sshd.common.random.AbstractRandom;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;

public final class BouncyCastleRandom
extends AbstractRandom {
    public static final String NAME = "BC";
    private final RandomGenerator random;

    public BouncyCastleRandom() {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        this.random = new VMPCRandomGenerator();
        byte[] byArray = new SecureRandom().generateSeed(8);
        this.random.addSeedMaterial(byArray);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void fill(byte[] byArray, int n2, int n3) {
        this.random.nextBytes(byArray, n2, n3);
    }

    @Override
    public int random(int n2) {
        int n3;
        int n4;
        ValidateUtils.checkTrue(n2 > 0, "Limit must be positive: %d", n2);
        if ((n2 & -n2) == n2) {
            return (int)((long)n2 * (long)this.next(31) >> 31);
        }
        while ((n4 = this.next(31)) - (n3 = n4 % n2) + (n2 - 1) < 0) {
        }
        return n3;
    }

    private int next(int n2) {
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        this.random.nextBytes(byArray);
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = byArray[i2] & 0xFF | n4 << 8;
        }
        return n4 >>> n3 * 8 - n2;
    }
}

