/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.CredentialException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class BouncyCastleKeyPairResourceParser
extends AbstractKeyPairResourceParser {
    public static final List BEGINNERS = Collections.unmodifiableList(Arrays.asList("BEGIN RSA PRIVATE KEY", "BEGIN DSA PRIVATE KEY", "BEGIN EC PRIVATE KEY"));
    public static final List ENDERS = Collections.unmodifiableList(Arrays.asList("END RSA PRIVATE KEY", "END DSA PRIVATE KEY", "END EC PRIVATE KEY"));
    public static final BouncyCastleKeyPairResourceParser INSTANCE = new BouncyCastleKeyPairResourceParser();

    public BouncyCastleKeyPairResourceParser() {
        super(BEGINNERS, ENDERS);
    }

    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string2, String string3, FilePasswordProvider filePasswordProvider, List list, Map map) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() + string3.length() + list.size() * 80);
        stringBuilder.append(string2).append(IoUtils.EOL);
        list.forEach(string -> stringBuilder.append((String)string).append(IoUtils.EOL));
        stringBuilder.append(string3).append(IoUtils.EOL);
        String string4 = stringBuilder.toString();
        byte[] byArray = string4.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            Collection collection = this.extractKeyPairs(sessionContext, namedResource, string2, string3, filePasswordProvider, byteArrayInputStream, map);
            return collection;
        }
    }

    @Override
    public Collection extractKeyPairs(SessionContext sessionContext, NamedResource namedResource, String string, String string2, FilePasswordProvider filePasswordProvider, InputStream inputStream, Map map) {
        KeyPair keyPair = BouncyCastleKeyPairResourceParser.loadKeyPair(sessionContext, namedResource, inputStream, filePasswordProvider);
        return keyPair == null ? Collections.emptyList() : Collections.singletonList(keyPair);
    }

    public static KeyPair loadKeyPair(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream, FilePasswordProvider filePasswordProvider) {
        Throwable throwable = null;
        try (PEMParser pEMParser = new PEMParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            Object object;
            Object object2 = pEMParser.readObject();
            SecurityProviderRegistrar securityProviderRegistrar = SecurityUtils.getRegisteredProvider("BC");
            if (securityProviderRegistrar == null) {
                throw new NoSuchProviderException("BC registrar not available");
            }
            JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
            if (securityProviderRegistrar.isNamedProviderUsed()) {
                jcaPEMKeyConverter.setProvider(securityProviderRegistrar.getName());
            } else {
                jcaPEMKeyConverter.setProvider(securityProviderRegistrar.getSecurityProvider());
            }
            if (object2 instanceof PEMEncryptedKeyPair) {
                if (filePasswordProvider == null) {
                    throw new CredentialException("Missing password provider for encrypted resource=" + namedResource);
                }
                object = (PEMEncryptedKeyPair)object2;
                object2 = filePasswordProvider.decode(sessionContext, namedResource, arg_0 -> BouncyCastleKeyPairResourceParser.lambda$loadKeyPair$1((PEMEncryptedKeyPair)object, arg_0));
            }
            if (object2 instanceof PEMKeyPair) {
                object = jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object2);
                return object;
            }
            if (object2 instanceof KeyPair) {
                object = (KeyPair)object2;
                return object;
            }
            try {
                throw new IOException("Failed to read " + namedResource + " - unknown result object: " + object2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static /* synthetic */ PEMKeyPair lambda$loadKeyPair$1(PEMEncryptedKeyPair pEMEncryptedKeyPair, String string) {
        JcePEMDecryptorProviderBuilder jcePEMDecryptorProviderBuilder = new JcePEMDecryptorProviderBuilder();
        PEMDecryptorProvider pEMDecryptorProvider = jcePEMDecryptorProviderBuilder.build(string.toCharArray());
        return pEMEncryptedKeyPair.decryptKeyPair(pEMDecryptorProvider);
    }
}

