/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class BouncyCastleGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public BouncyCastleGeneratorHostKeyProvider(Path path) {
        this.setPath(path);
    }

    @Override
    protected void doWriteKeyPair(NamedResource namedResource, KeyPair keyPair, OutputStream outputStream) {
        BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(keyPair, outputStream);
    }

    public static void writePEMKeyPair(KeyPair keyPair, Path path) {
        BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(keyPair, path, IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static void writePEMKeyPair(KeyPair keyPair, Path path, OpenOption ... openOptionArray) {
        try (OutputStream outputStream = Files.newOutputStream(path, openOptionArray);){
            BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(keyPair, outputStream);
        }
    }

    public static void writePEMKeyPair(KeyPair keyPair, OutputStream outputStream) {
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            jcaPEMWriter.writeObject((Object)keyPair);
            jcaPEMWriter.flush();
        }
    }
}

