/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import org.apache.sshd.common.util.security.Decryptor;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

public enum BouncyCastleEncryptedPrivateKeyInfoDecryptor implements Decryptor
{
    INSTANCE;


    @Override
    public byte[] decrypt(byte[] byArray, char[] cArray) {
        SecurityProviderRegistrar securityProviderRegistrar = SecurityUtils.getRegisteredProvider("BC");
        if (securityProviderRegistrar == null) {
            throw new NoSuchProviderException("BC registrar not available");
        }
        try {
            JcePKCSPBEInputDecryptorProviderBuilder jcePKCSPBEInputDecryptorProviderBuilder = new JcePKCSPBEInputDecryptorProviderBuilder();
            if (securityProviderRegistrar.isNamedProviderUsed()) {
                jcePKCSPBEInputDecryptorProviderBuilder.setProvider(securityProviderRegistrar.getName());
            } else {
                jcePKCSPBEInputDecryptorProviderBuilder.setProvider(securityProviderRegistrar.getSecurityProvider());
            }
            PKCS8EncryptedPrivateKeyInfo pKCS8EncryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(byArray);
            return pKCS8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(jcePKCSPBEInputDecryptorProviderBuilder.build(cArray)).getEncoded("DER");
        }
        catch (IOException | PKCSException throwable) {
            throw new GeneralSecurityException(throwable);
        }
    }
}

