/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.DHParameterSpec;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.PEMResourceParserUtils;
import org.apache.sshd.common.random.JceRandomFactory;
import org.apache.sshd.common.random.RandomFactory;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.Decryptor;
import org.apache.sshd.common.util.security.SecurityEntityFactory;
import org.apache.sshd.common.util.security.SecurityProviderChoice;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleEncryptedPrivateKeyInfoDecryptor;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleGeneratorHostKeyProvider;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleKeyPairResourceParser;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleRandomFactory;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    public static final String BOUNCY_CASTLE = "BC";
    public static final String EDDSA = "EdDSA";
    public static final String CURVE_ED25519_SHA512 = "NONEwithEdDSA";
    public static final String MIN_DHGEX_KEY_SIZE_PROP = "org.apache.sshd.minDHGexKeySize";
    public static final String MAX_DHGEX_KEY_SIZE_PROP = "org.apache.sshd.maxDHGexKeySize";
    public static final int MIN_DHGEX_KEY_SIZE = 2048;
    public static final int PREFERRED_DHGEX_KEY_SIZE = 4096;
    public static final int MAX_DHGEX_KEY_SIZE = 8192;
    public static final String SECURITY_PROVIDER_REGISTRARS = "org.apache.sshd.security.registrars";
    public static final List DEFAULT_SECURITY_PROVIDER_REGISTRARS = Collections.unmodifiableList(Arrays.asList("org.apache.sshd.common.util.security.bouncycastle.BouncyCastleSecurityProviderRegistrar", "org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderRegistrar"));
    @Deprecated
    public static final String REGISTER_BOUNCY_CASTLE_PROP = "org.apache.sshd.registerBouncyCastle";
    public static final String ECC_SUPPORTED_PROP = "org.apache.sshd.eccSupport";
    @Deprecated
    public static final String EDDSA_SUPPORTED_PROP = "org.apache.sshd.eddsaSupport";
    public static final String PROP_DEFAULT_SECURITY_PROVIDER = "org.apache.sshd.security.defaultProvider";
    private static final AtomicInteger MIN_DHG_KEY_SIZE_HOLDER = new AtomicInteger(0);
    private static final AtomicInteger MAX_DHG_KEY_SIZE_HOLDER = new AtomicInteger(0);
    private static final Map REGISTERED_PROVIDERS = new LinkedHashMap();
    private static final AtomicReference KEYPAIRS_PARSER_HODLER = new AtomicReference();
    private static final Set APRIORI_DISABLED_PROVIDERS = new TreeSet();
    private static final AtomicBoolean REGISTRATION_STATE_HOLDER = new AtomicBoolean(false);
    private static final Map SECURITY_ENTITY_FACTORIES = new HashMap();
    private static final AtomicReference DEFAULT_PROVIDER_HOLDER = new AtomicReference();
    private static Boolean hasEcc;

    private SecurityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAPrioriDisabledProvider(String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No provider name specified");
        Set set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            return APRIORI_DISABLED_PROVIDERS.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAPrioriDisabledProvider(String string, boolean bl2) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No provider name specified");
        Set set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            if (bl2) {
                APRIORI_DISABLED_PROVIDERS.add(string);
            } else {
                APRIORI_DISABLED_PROVIDERS.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAPrioriDisabledProviders() {
        Set set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            return new TreeSet(APRIORI_DISABLED_PROVIDERS);
        }
    }

    public static boolean isECCSupported() {
        if (hasEcc == null) {
            String string = System.getProperty(ECC_SUPPORTED_PROP);
            if (GenericUtils.isEmpty(string)) {
                try {
                    SecurityUtils.getKeyPairGenerator("EC");
                    hasEcc = Boolean.TRUE;
                }
                catch (Throwable throwable) {
                    hasEcc = Boolean.FALSE;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override ECC support value: {}", (Object)string);
                hasEcc = Boolean.valueOf(string);
            }
        }
        return hasEcc;
    }

    public static boolean isDHGroupExchangeSupported() {
        int n2 = SecurityUtils.getMaxDHGroupExchangeKeySize();
        int n3 = SecurityUtils.getMinDHGroupExchangeKeySize();
        return n3 > 0 && n2 > 0 && n3 <= n2;
    }

    public static boolean isDHOakelyGroupSupported(int n2) {
        return SecurityUtils.isDHGroupExchangeSupported() && SecurityUtils.getMaxDHGroupExchangeKeySize() >= n2;
    }

    public static int getMinDHGroupExchangeKeySize() {
        return SecurityUtils.resolveDHGEXKeySizeValue(MIN_DHG_KEY_SIZE_HOLDER, MIN_DHGEX_KEY_SIZE_PROP, 2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMinDHGroupExchangeKeySize(int n2) {
        AtomicInteger atomicInteger = MIN_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            MIN_DHG_KEY_SIZE_HOLDER.set(n2);
        }
    }

    public static int getMaxDHGroupExchangeKeySize() {
        return SecurityUtils.resolveDHGEXKeySizeValue(MAX_DHG_KEY_SIZE_HOLDER, MAX_DHGEX_KEY_SIZE_PROP, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxDHGroupExchangeKeySize(int n2) {
        AtomicInteger atomicInteger = MAX_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            MAX_DHG_KEY_SIZE_HOLDER.set(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolveDHGEXKeySizeValue(AtomicInteger atomicInteger, String string, int n2) {
        int n3;
        AtomicInteger atomicInteger2 = atomicInteger;
        synchronized (atomicInteger2) {
            n3 = atomicInteger.get();
            if (n3 != 0) {
                return n3;
            }
            String string2 = System.getProperty(string);
            if (GenericUtils.isEmpty(string2)) {
                n3 = -1;
                for (int i2 = n2; i2 >= 2048; i2 -= 1024) {
                    if (!SecurityUtils.isDHGroupExchangeSupported(i2)) continue;
                    n3 = i2;
                    break;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override DH group exchange key size via {}: {}", (Object)string, (Object)string2);
                n3 = Integer.parseInt(string2);
                ValidateUtils.checkTrue(n3 != 0, "Configured " + string + " value must be non-zero: %d", n3);
            }
            atomicInteger.set(n3);
        }
        return n3;
    }

    public static boolean isDHGroupExchangeSupported(int n2) {
        ValidateUtils.checkTrue(n2 > 8, "Invalid max. key size: %d", n2);
        try {
            BigInteger bigInteger = BigInteger.ZERO.setBit(n2 - 1);
            DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger);
            KeyPairGenerator keyPairGenerator = SecurityUtils.getKeyPairGenerator("DH");
            keyPairGenerator.initialize(dHParameterSpec);
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderChoice getDefaultProviderChoice() {
        SecurityProviderChoice securityProviderChoice;
        AtomicReference atomicReference = DEFAULT_PROVIDER_HOLDER;
        synchronized (atomicReference) {
            securityProviderChoice = (SecurityProviderChoice)DEFAULT_PROVIDER_HOLDER.get();
            if (securityProviderChoice != null) {
                return securityProviderChoice;
            }
            String string = System.getProperty(PROP_DEFAULT_SECURITY_PROVIDER);
            securityProviderChoice = GenericUtils.isEmpty(string) || PropertyResolverUtils.isNoneValue(string) ? SecurityProviderChoice.EMPTY : SecurityProviderChoice.toSecurityProviderChoice(string);
            DEFAULT_PROVIDER_HOLDER.set(securityProviderChoice);
        }
        return securityProviderChoice;
    }

    public static void setDefaultProviderChoice(SecurityProviderChoice securityProviderChoice) {
        DEFAULT_PROVIDER_HOLDER.set(securityProviderChoice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getRegisteredProviders() {
        Map map = REGISTERED_PROVIDERS;
        synchronized (map) {
            return new TreeSet(REGISTERED_PROVIDERS.keySet());
        }
    }

    public static boolean isBouncyCastleRegistered() {
        SecurityUtils.register();
        return SecurityUtils.isProviderRegistered(BOUNCY_CASTLE);
    }

    public static boolean isProviderRegistered(String string) {
        return SecurityUtils.getRegisteredProvider(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderRegistrar getRegisteredProvider(String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No provider name specified");
        Map map = REGISTERED_PROVIDERS;
        synchronized (map) {
            return (SecurityProviderRegistrar)REGISTERED_PROVIDERS.get(string);
        }
    }

    public static boolean isRegistrationCompleted() {
        return REGISTRATION_STATE_HOLDER.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register() {
        AtomicBoolean atomicBoolean = REGISTRATION_STATE_HOLDER;
        synchronized (atomicBoolean) {
            String[] stringArray;
            if (REGISTRATION_STATE_HOLDER.get()) {
                return;
            }
            String string = System.getProperty(SECURITY_PROVIDER_REGISTRARS, GenericUtils.join((Iterable)DEFAULT_SECURITY_PROVIDER_REGISTRARS, ','));
            boolean bl2 = false;
            if (GenericUtils.length(string) > 0 && !PropertyResolverUtils.isNoneValue(string)) {
                stringArray = GenericUtils.split(string, ',');
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                boolean bl3 = logger.isDebugEnabled();
                for (String string2 : stringArray) {
                    Object object;
                    SecurityProviderRegistrar securityProviderRegistrar;
                    try {
                        securityProviderRegistrar = (SecurityProviderRegistrar)ThreadUtils.createDefaultInstance(SecurityUtils.class, SecurityProviderRegistrar.class, string2);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        object = ExceptionUtils.peelException(reflectiveOperationException);
                        logger.error("Failed ({}) to create default {} registrar instance: {}", new Object[]{object.getClass().getSimpleName(), string2, ((Throwable)object).getMessage()});
                        if (object instanceof RuntimeException) {
                            throw (RuntimeException)object;
                        }
                        if (object instanceof Error) {
                            throw (Error)object;
                        }
                        throw new IllegalStateException((Throwable)object);
                    }
                    String string3 = securityProviderRegistrar.getName();
                    object = SecurityUtils.registerSecurityProvider(securityProviderRegistrar);
                    if (object == null) {
                        if (!bl3) continue;
                        logger.debug("register({}) not registered - enabled={}, supported={}", new Object[]{string3, securityProviderRegistrar.isEnabled(), securityProviderRegistrar.isSupported()});
                        continue;
                    }
                    if (!BOUNCY_CASTLE.equalsIgnoreCase(string3)) continue;
                    bl2 = true;
                }
            }
            if (((stringArray = SecurityUtils.getDefaultProviderChoice()) == null || stringArray == SecurityProviderChoice.EMPTY) && bl2) {
                SecurityUtils.setDefaultProviderChoice(SecurityProviderChoice.toSecurityProviderChoice(BOUNCY_CASTLE));
            }
            REGISTRATION_STATE_HOLDER.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderRegistrar registerSecurityProvider(SecurityProviderRegistrar securityProviderRegistrar) {
        Objects.requireNonNull(securityProviderRegistrar, "No registrar instance to register");
        String string = securityProviderRegistrar.getName();
        SecurityProviderRegistrar securityProviderRegistrar2 = SecurityUtils.getRegisteredProvider(string);
        if (securityProviderRegistrar2 == null && securityProviderRegistrar.isEnabled() && securityProviderRegistrar.isSupported()) {
            try {
                SecurityProviderRegistrar.registerSecurityProvider(securityProviderRegistrar);
                Map map = REGISTERED_PROVIDERS;
                synchronized (map) {
                    REGISTERED_PROVIDERS.put(string, securityProviderRegistrar);
                }
                return securityProviderRegistrar;
            }
            catch (Throwable throwable) {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.error("Failed {} to register {} as a JCE provider: {}", new Object[]{throwable.getClass().getSimpleName(), string, throwable.getMessage()});
                throw new IllegalArgumentException("Failed to register " + string + " as a JCE provider", throwable);
            }
        }
        return securityProviderRegistrar2;
    }

    public static Iterable loadKeyPairIdentities(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream, FilePasswordProvider filePasswordProvider) {
        KeyPairResourceParser keyPairResourceParser = SecurityUtils.getKeyPairResourceParser();
        if (keyPairResourceParser == null) {
            throw new NoSuchProviderException("No registered key-pair resource parser");
        }
        Collection collection = keyPairResourceParser.loadKeyPairs(sessionContext, namedResource, filePasswordProvider, inputStream);
        int n2 = GenericUtils.size(collection);
        if (n2 <= 0) {
            return null;
        }
        return collection;
    }

    public static AbstractGeneratorHostKeyProvider createGeneratorHostKeyProvider(Path path) {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return new BouncyCastleGeneratorHostKeyProvider(path);
    }

    public static KeyPairResourceParser getBouncycastleKeyPairResourceParser() {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return BouncyCastleKeyPairResourceParser.INSTANCE;
    }

    public static Decryptor getBouncycastleEncryptedPrivateKeyInfoDecryptor() {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return BouncyCastleEncryptedPrivateKeyInfoDecryptor.INSTANCE;
    }

    public static RandomFactory getRandomFactory() {
        if (SecurityUtils.isBouncyCastleRegistered()) {
            return BouncyCastleRandomFactory.INSTANCE;
        }
        return JceRandomFactory.INSTANCE;
    }

    public static boolean isEDDSACurveSupported() {
        SecurityUtils.register();
        SecurityProviderRegistrar securityProviderRegistrar = SecurityUtils.getRegisteredProvider(EDDSA);
        return securityProviderRegistrar != null && securityProviderRegistrar.isEnabled() && securityProviderRegistrar.isSupported();
    }

    public static PublicKeyEntryDecoder getEDDSAPublicKeyEntryDecoder() {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider N/A");
        }
        return EdDSASecurityProviderUtils.getEDDSAPublicKeyEntryDecoder();
    }

    public static PrivateKeyEntryDecoder getOpenSSHEDDSAPrivateKeyEntryDecoder() {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider N/A");
        }
        return EdDSASecurityProviderUtils.getOpenSSHEDDSAPrivateKeyEntryDecoder();
    }

    public static Signature getEDDSASigner() {
        if (SecurityUtils.isEDDSACurveSupported()) {
            return EdDSASecurityProviderUtils.getEDDSASignature();
        }
        throw new UnsupportedOperationException("EdDSA Signer not available");
    }

    public static int getEDDSAKeySize(Key key) {
        return EdDSASecurityProviderUtils.getEDDSAKeySize(key);
    }

    public static Class getEDDSAPublicKeyType() {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProviderUtils.getEDDSAPublicKeyType() : PublicKey.class;
    }

    public static Class getEDDSAPrivateKeyType() {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProviderUtils.getEDDSAPrivateKeyType() : PrivateKey.class;
    }

    public static boolean compareEDDSAPPublicKeys(PublicKey publicKey, PublicKey publicKey2) {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProviderUtils.compareEDDSAPPublicKeys(publicKey, publicKey2) : false;
    }

    public static boolean compareEDDSAPrivateKeys(PrivateKey privateKey, PrivateKey privateKey2) {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProviderUtils.compareEDDSAPrivateKeys(privateKey, privateKey2) : false;
    }

    public static PublicKey recoverEDDSAPublicKey(PrivateKey privateKey) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        return EdDSASecurityProviderUtils.recoverEDDSAPublicKey(privateKey);
    }

    public static PublicKey generateEDDSAPublicKey(String string, byte[] byArray) {
        if (!"ssh-ed25519".equals(string)) {
            throw new InvalidKeyException("Unsupported key type: " + string);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        return EdDSASecurityProviderUtils.generateEDDSAPublicKey(byArray);
    }

    public static Buffer putRawEDDSAPublicKey(Buffer buffer, PublicKey publicKey) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider not supported");
        }
        return EdDSASecurityProviderUtils.putRawEDDSAPublicKey(buffer, publicKey);
    }

    public static Buffer putEDDSAKeyPair(Buffer buffer, KeyPair keyPair) {
        return SecurityUtils.putEDDSAKeyPair(buffer, Objects.requireNonNull(keyPair, "No key pair").getPublic(), keyPair.getPrivate());
    }

    public static Buffer putEDDSAKeyPair(Buffer buffer, PublicKey publicKey, PrivateKey privateKey) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider not supported");
        }
        return EdDSASecurityProviderUtils.putEDDSAKeyPair(buffer, publicKey, privateKey);
    }

    public static KeyPair extractEDDSAKeyPair(Buffer buffer, String string) {
        if (!"ssh-ed25519".equals(string)) {
            throw new InvalidKeyException("Unsupported key type: " + string);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        throw new GeneralSecurityException("Full SSHD-440 implementation N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairResourceParser getKeyPairResourceParser() {
        KeyPairResourceParser keyPairResourceParser;
        AtomicReference atomicReference = KEYPAIRS_PARSER_HODLER;
        synchronized (atomicReference) {
            keyPairResourceParser = (KeyPairResourceParser)KEYPAIRS_PARSER_HODLER.get();
            if (keyPairResourceParser != null) {
                return keyPairResourceParser;
            }
            keyPairResourceParser = KeyPairResourceParser.aggregate(PEMResourceParserUtils.PROXY, OpenSSHKeyPairResourceParser.INSTANCE);
            KEYPAIRS_PARSER_HODLER.set(keyPairResourceParser);
        }
        return keyPairResourceParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKeyPairResourceParser(KeyPairResourceParser keyPairResourceParser) {
        AtomicReference atomicReference = KEYPAIRS_PARSER_HODLER;
        synchronized (atomicReference) {
            KEYPAIRS_PARSER_HODLER.set(keyPairResourceParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityEntityFactory resolveSecurityEntityFactory(Class clazz2, String string2, Predicate predicate) {
        SecurityEntityFactory securityEntityFactory;
        Map map;
        Object object = SECURITY_ENTITY_FACTORIES;
        synchronized (object) {
            map = SECURITY_ENTITY_FACTORIES.computeIfAbsent(clazz2, clazz -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        }
        object = SecurityProviderRegistrar.getEffectiveSecurityEntityName(clazz2, string2);
        Map map2 = map;
        synchronized (map2) {
            securityEntityFactory = map.computeIfAbsent(object, string -> SecurityUtils.createSecurityEntityFactory(clazz2, predicate));
        }
        return securityEntityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityEntityFactory createSecurityEntityFactory(Class clazz, Predicate predicate) {
        SecurityProviderRegistrar securityProviderRegistrar;
        SecurityUtils.register();
        Map map = REGISTERED_PROVIDERS;
        synchronized (map) {
            securityProviderRegistrar = SecurityProviderRegistrar.findSecurityProviderRegistrarBySecurityEntity(predicate, REGISTERED_PROVIDERS.values());
        }
        try {
            return SecurityEntityFactory.toFactory(clazz, securityProviderRegistrar, SecurityUtils.getDefaultProviderChoice());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Throwable throwable = ExceptionUtils.peelException(reflectiveOperationException);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IllegalArgumentException(throwable);
        }
    }

    public static KeyFactory getKeyFactory(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(KeyFactory.class, string, securityProviderRegistrar -> securityProviderRegistrar.isKeyFactorySupported(string));
        return (KeyFactory)securityEntityFactory.getInstance(string);
    }

    public static Cipher getCipher(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(Cipher.class, string, securityProviderRegistrar -> securityProviderRegistrar.isCipherSupported(string));
        return (Cipher)securityEntityFactory.getInstance(string);
    }

    public static MessageDigest getMessageDigest(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(MessageDigest.class, string, securityProviderRegistrar -> securityProviderRegistrar.isMessageDigestSupported(string));
        return (MessageDigest)securityEntityFactory.getInstance(string);
    }

    public static KeyPairGenerator getKeyPairGenerator(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(KeyPairGenerator.class, string, securityProviderRegistrar -> securityProviderRegistrar.isKeyPairGeneratorSupported(string));
        return (KeyPairGenerator)securityEntityFactory.getInstance(string);
    }

    public static KeyAgreement getKeyAgreement(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(KeyAgreement.class, string, securityProviderRegistrar -> securityProviderRegistrar.isKeyAgreementSupported(string));
        return (KeyAgreement)securityEntityFactory.getInstance(string);
    }

    public static Mac getMac(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(Mac.class, string, securityProviderRegistrar -> securityProviderRegistrar.isMacSupported(string));
        return (Mac)securityEntityFactory.getInstance(string);
    }

    public static java.security.Signature getSignature(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(java.security.Signature.class, string, securityProviderRegistrar -> securityProviderRegistrar.isSignatureSupported(string));
        return (java.security.Signature)securityEntityFactory.getInstance(string);
    }

    public static CertificateFactory getCertificateFactory(String string) {
        SecurityEntityFactory securityEntityFactory = SecurityUtils.resolveSecurityEntityFactory(CertificateFactory.class, string, securityProviderRegistrar -> securityProviderRegistrar.isCertificateFactorySupported(string));
        return (CertificateFactory)securityEntityFactory.getInstance(string);
    }
}

