/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SyspropsMapWrapper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.IgnoringEmptyMap;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityProviderChoice;
import org.apache.sshd.common.util.security.SecurityUtils;

public interface SecurityProviderRegistrar
extends OptionalFeature,
PropertyResolver,
SecurityProviderChoice {
    public static final String CONFIG_PROP_BASE = "org.apache.sshd.security.provider";
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String NAMED_PROVIDER_PROPERTY = "useNamed";
    public static final String ALL_OPTIONS_VALUE = "all";
    public static final String ALL_OPTIONS_WILDCARD = "*";
    public static final String NO_OPTIONS_VALUE = "none";
    public static final List SECURITY_ENTITIES = Collections.unmodifiableList(Arrays.asList(Cipher.class, KeyFactory.class, MessageDigest.class, KeyPairGenerator.class, KeyAgreement.class, Mac.class, Signature.class, CertificateFactory.class));

    default public String getBasePropertyName() {
        return "org.apache.sshd.security.provider." + this.getName();
    }

    default public String getConfigurationPropertyName(String string) {
        return this.getBasePropertyName() + "." + string;
    }

    default public boolean isEnabled() {
        if (SecurityUtils.isAPrioriDisabledProvider(this.getName())) {
            return false;
        }
        String string = this.getConfigurationPropertyName(ENABLED_PROPERTY);
        return this.getBooleanProperty(string, true);
    }

    @Override
    default public PropertyResolver getParentPropertyResolver() {
        return SyspropsMapWrapper.RAW_PROPS_RESOLVER;
    }

    @Override
    default public Map getProperties() {
        return IgnoringEmptyMap.getInstance();
    }

    default public boolean isCipherSupported(String string) {
        return this.isSecurityEntitySupported(Cipher.class, string);
    }

    default public boolean isKeyFactorySupported(String string) {
        return this.isSecurityEntitySupported(KeyFactory.class, string);
    }

    default public boolean isMessageDigestSupported(String string) {
        return this.isSecurityEntitySupported(MessageDigest.class, string);
    }

    default public boolean isKeyPairGeneratorSupported(String string) {
        return this.isSecurityEntitySupported(KeyPairGenerator.class, string);
    }

    default public boolean isKeyAgreementSupported(String string) {
        return this.isSecurityEntitySupported(KeyAgreement.class, string);
    }

    default public boolean isMacSupported(String string) {
        return this.isSecurityEntitySupported(Mac.class, string);
    }

    default public boolean isSignatureSupported(String string) {
        return this.isSecurityEntitySupported(Signature.class, string);
    }

    default public boolean isCertificateFactorySupported(String string) {
        return this.isSecurityEntitySupported(CertificateFactory.class, string);
    }

    default public String getDefaultSecurityEntitySupportValue(Class clazz) {
        return "";
    }

    default public boolean isSecurityEntitySupported(Class clazz, String string) {
        String string2 = this.getDefaultSecurityEntitySupportValue(clazz);
        return SecurityProviderRegistrar.isSecurityEntitySupported(this, clazz, string, string2);
    }

    @Override
    default public boolean isNamedProviderUsed() {
        return PropertyResolverUtils.getBooleanProperty(this, this.getConfigurationPropertyName(NAMED_PROVIDER_PROPERTY), SecurityProviderChoice.super.isNamedProviderUsed());
    }

    public static boolean isAllOptionsValue(String string) {
        return ALL_OPTIONS_VALUE.equalsIgnoreCase(string) || ALL_OPTIONS_WILDCARD.equalsIgnoreCase(string);
    }

    public static boolean isSecurityEntitySupported(SecurityProviderRegistrar securityProviderRegistrar, Class clazz, String string, String string2) {
        return Objects.requireNonNull(securityProviderRegistrar, "No registrar instance").isSupported() && SecurityProviderRegistrar.isSecurityEntitySupported(securityProviderRegistrar, securityProviderRegistrar.getConfigurationPropertyName(clazz.getSimpleName()), clazz, string, string2);
    }

    public static boolean isSecurityEntitySupported(PropertyResolver propertyResolver, String string, Class clazz, String string2, String string3) {
        if (GenericUtils.isEmpty(string2)) {
            return false;
        }
        String string4 = propertyResolver.getString(string);
        if (GenericUtils.isEmpty(string4)) {
            string4 = string3;
        }
        if (NO_OPTIONS_VALUE.equalsIgnoreCase(string4)) {
            return false;
        }
        Object[] objectArray = GenericUtils.split(string4, ',');
        if (GenericUtils.isEmpty(objectArray)) {
            return false;
        }
        if (objectArray.length == 1 && SecurityProviderRegistrar.isAllOptionsValue((String)objectArray[0])) {
            return true;
        }
        String string5 = SecurityProviderRegistrar.getEffectiveSecurityEntityName(clazz, string2);
        int n2 = Arrays.binarySearch(objectArray, string5, String.CASE_INSENSITIVE_ORDER);
        return n2 >= 0;
    }

    public static String getEffectiveSecurityEntityName(Class clazz, String string) {
        if (clazz == null || GenericUtils.isEmpty(string) || !Cipher.class.isAssignableFrom(clazz)) {
            return string;
        }
        int n2 = string.indexOf(47);
        return n2 > 0 ? string.substring(0, n2) : string;
    }

    public static boolean registerSecurityProvider(SecurityProviderRegistrar securityProviderRegistrar) {
        String string = ValidateUtils.checkNotNullAndNotEmpty(securityProviderRegistrar == null ? null : securityProviderRegistrar.getName(), "No name for registrar=%s", (Object)securityProviderRegistrar);
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            return false;
        }
        provider = (Provider)ValidateUtils.checkNotNull((Object)securityProviderRegistrar.getSecurityProvider(), "No provider created for registrar of %s", (Object)string);
        if (securityProviderRegistrar.isNamedProviderUsed()) {
            Security.addProvider(provider);
        }
        return true;
    }

    public static SecurityProviderRegistrar findSecurityProviderRegistrarBySecurityEntity(Predicate predicate, Collection collection) {
        return (SecurityProviderRegistrar)GenericUtils.findFirstMatchingMember(securityProviderRegistrar -> securityProviderRegistrar.isEnabled() && securityProviderRegistrar.isSupported() && predicate.test(securityProviderRegistrar), collection);
    }
}

