/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.Provider;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityProviderChoice$1;
import org.apache.sshd.common.util.security.SecurityProviderChoice$2;
import org.apache.sshd.common.util.security.SecurityProviderChoice$3;
import org.apache.sshd.common.util.threads.ThreadUtils;

public interface SecurityProviderChoice
extends NamedResource {
    public static final SecurityProviderChoice EMPTY = new SecurityProviderChoice$1();

    default public boolean isNamedProviderUsed() {
        return true;
    }

    public Provider getSecurityProvider();

    public static SecurityProviderChoice toSecurityProviderChoice(String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No name provided");
        return new SecurityProviderChoice$2(string);
    }

    public static SecurityProviderChoice toSecurityProviderChoice(Provider provider) {
        Objects.requireNonNull(provider, "No provider instance");
        return new SecurityProviderChoice$3(provider);
    }

    public static Provider createProviderInstance(Class clazz, String string) {
        return (Provider)ThreadUtils.createDefaultInstance(clazz, Provider.class, string);
    }
}

