/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.lang.reflect.Method;
import java.security.Provider;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityEntityFactory$1;
import org.apache.sshd.common.util.security.SecurityEntityFactory$2;
import org.apache.sshd.common.util.security.SecurityEntityFactory$3;
import org.apache.sshd.common.util.security.SecurityProviderChoice;

public interface SecurityEntityFactory {
    public Class getEntityType();

    public Object getInstance(String var1);

    public static SecurityEntityFactory toFactory(Class clazz, SecurityProviderChoice securityProviderChoice, SecurityProviderChoice securityProviderChoice2) {
        if (securityProviderChoice == null) {
            if (securityProviderChoice2 == null || securityProviderChoice2 == SecurityProviderChoice.EMPTY) {
                return SecurityEntityFactory.toDefaultFactory(clazz);
            }
            if (securityProviderChoice2.isNamedProviderUsed()) {
                return SecurityEntityFactory.toNamedProviderFactory(clazz, securityProviderChoice2.getName());
            }
            return SecurityEntityFactory.toProviderInstanceFactory(clazz, securityProviderChoice2.getSecurityProvider());
        }
        if (securityProviderChoice.isNamedProviderUsed()) {
            return SecurityEntityFactory.toNamedProviderFactory(clazz, securityProviderChoice.getName());
        }
        return SecurityEntityFactory.toProviderInstanceFactory(clazz, securityProviderChoice.getSecurityProvider());
    }

    public static SecurityEntityFactory toDefaultFactory(Class clazz) {
        Method method = clazz.getDeclaredMethod("getInstance", String.class);
        return new SecurityEntityFactory$1(clazz, method);
    }

    public static SecurityEntityFactory toNamedProviderFactory(Class clazz, String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No provider name specified");
        Method method = clazz.getDeclaredMethod("getInstance", String.class, String.class);
        return new SecurityEntityFactory$2(clazz, string, method);
    }

    public static SecurityEntityFactory toProviderInstanceFactory(Class clazz, Provider provider) {
        Objects.requireNonNull(provider, "No provider instance");
        Method method = clazz.getDeclaredMethod("getInstance", String.class, Provider.class);
        return new SecurityEntityFactory$3(clazz, provider, method);
    }
}

