/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.security.SecurityProviderChoice;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;

public abstract class AbstractSecurityProviderRegistrar
extends AbstractLoggingBean
implements SecurityProviderRegistrar {
    protected final Map props = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    protected final Map supportedEntities = new HashMap();
    protected final AtomicReference providerHolder = new AtomicReference<Object>(null);
    private final String name;

    protected AbstractSecurityProviderRegistrar(String string) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(string, "No name provided");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Map getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSecurityEntitySupported(Class clazz2, String string) {
        Map map;
        Object object = this.supportedEntities;
        synchronized (object) {
            map = this.supportedEntities.computeIfAbsent(clazz2, clazz -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        }
        Map map2 = map;
        synchronized (map2) {
            object = map.computeIfAbsent(string, string2 -> SecurityProviderRegistrar.super.isSecurityEntitySupported(clazz2, string));
        }
        return (Boolean)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Provider getOrCreateProvider(String string) {
        Provider provider;
        if (!this.isSupported()) {
            throw new UnsupportedOperationException("Provider not supported");
        }
        boolean bl2 = false;
        AtomicReference atomicReference = this.providerHolder;
        synchronized (atomicReference) {
            provider = (Provider)this.providerHolder.get();
            if (provider != null) {
                return provider;
            }
            provider = Security.getProvider(this.getName());
            if (provider == null) {
                provider = this.createProviderInstance(string);
                bl2 = true;
            }
            this.providerHolder.set(provider);
        }
        if (bl2) {
            this.log.info("getOrCreateProvider({}) created instance of {}", (Object)this.getName(), (Object)string);
        } else {
            this.log.info("getOrCreateProvider({}) resolved instance of {}", (Object)this.getName(), (Object)provider.getClass().getName());
        }
        return provider;
    }

    protected Provider createProviderInstance(String string) {
        return SecurityProviderChoice.createProviderInstance(this.getClass(), string);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

