/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class SshdSocketAddress
extends SocketAddress {
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOCALHOST_IPV4 = "127.0.0.1";
    public static final String IPV4_ANYADDR = "0.0.0.0";
    public static final Set WELL_KNOWN_IPV4_ADDRESSES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("127.0.0.1", "0.0.0.0")));
    public static final String PRIVATE_CLASS_A_PREFIX = "10.";
    public static final String PRIVATE_CLASS_B_PREFIX = "172.";
    public static final String PRIVATE_CLASS_C_PREFIX = "192.168.";
    public static final String CARRIER_GRADE_NAT_PREFIX = "100.";
    public static final String BROADCAST_ADDRESS = "255.255.255.255";
    public static final int IPV6_MAX_HEX_GROUPS = 8;
    public static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    public static final String IPV6_LONG_ANY_ADDRESS = "0:0:0:0:0:0:0:0";
    public static final String IPV6_SHORT_ANY_ADDRESS = "::";
    public static final String IPV6_LONG_LOCALHOST = "0:0:0:0:0:0:0:1";
    public static final String IPV6_SHORT_LOCALHOST = "::1";
    public static final Set WELL_KNOWN_IPV6_ADDRESSES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("0:0:0:0:0:0:0:1", "::1", "0:0:0:0:0:0:0:0", "::")));
    public static final SshdSocketAddress LOCALHOST_ADDRESS = new SshdSocketAddress("127.0.0.1", 0);
    public static final Comparator BY_HOST_ADDRESS = (inetAddress, inetAddress2) -> {
        String string = GenericUtils.trimToEmpty(SshdSocketAddress.toAddressString(inetAddress));
        String string2 = GenericUtils.trimToEmpty(SshdSocketAddress.toAddressString(inetAddress2));
        return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
    };
    public static final Comparator BY_HOST_AND_PORT = (socketAddress, socketAddress2) -> {
        int n2;
        String string;
        String string2 = GenericUtils.trimToEmpty(SshdSocketAddress.toAddressString(socketAddress));
        int n3 = String.CASE_INSENSITIVE_ORDER.compare(string2, string = GenericUtils.trimToEmpty(SshdSocketAddress.toAddressString(socketAddress2)));
        if (n3 != 0) {
            return n3;
        }
        int n4 = SshdSocketAddress.toAddressPort(socketAddress);
        n3 = Integer.compare(n4, n2 = SshdSocketAddress.toAddressPort(socketAddress2));
        if (n3 != 0) {
            return n3;
        }
        return 0;
    };
    private static final long serialVersionUID = 6461645947151952729L;
    private final String hostName;
    private final int port;

    public SshdSocketAddress(int n2) {
        this(IPV4_ANYADDR, n2);
    }

    public SshdSocketAddress(InetSocketAddress inetSocketAddress) {
        Objects.requireNonNull(inetSocketAddress, "No address provided");
        String string = inetSocketAddress.getHostString();
        this.hostName = GenericUtils.isEmpty(string) ? IPV4_ANYADDR : string;
        this.port = inetSocketAddress.getPort();
        ValidateUtils.checkTrue(this.port >= 0, "Port must be >= 0: %d", this.port);
    }

    public SshdSocketAddress(String string, int n2) {
        Objects.requireNonNull(string, "Host name may not be null");
        this.hostName = GenericUtils.isEmpty(string) ? IPV4_ANYADDR : string;
        ValidateUtils.checkTrue(n2 >= 0, "Port must be >= 0: %d", n2);
        this.port = n2;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.getHostName(), this.getPort());
    }

    public String toString() {
        return this.getHostName() + ":" + this.getPort();
    }

    protected boolean isEquivalent(SshdSocketAddress sshdSocketAddress) {
        if (sshdSocketAddress == null) {
            return false;
        }
        if (sshdSocketAddress == this) {
            return true;
        }
        return this.getPort() == sshdSocketAddress.getPort() && SshdSocketAddress.isEquivalentHostName(this.getHostName(), sshdSocketAddress.getHostName(), false);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.isEquivalent((SshdSocketAddress)object);
    }

    public int hashCode() {
        return GenericUtils.hashCode(this.getHostName(), Boolean.FALSE) + 31 * Integer.hashCode(this.getPort());
    }

    public static InetAddress getFirstExternalNetwork4Address() {
        List list = SshdSocketAddress.getExternalNetwork4Addresses();
        return GenericUtils.size(list) > 0 ? (InetAddress)list.get(0) : null;
    }

    public static List getExternalNetwork4Addresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration != null && enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!SshdSocketAddress.isValidHostAddress(inetAddress)) continue;
                    arrayList.add(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (GenericUtils.size(arrayList) > 1) {
            Collections.sort(arrayList, BY_HOST_ADDRESS);
        }
        return arrayList;
    }

    public static boolean isValidHostAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return false;
        }
        if (inetAddress.isLinkLocalAddress()) {
            return false;
        }
        if (inetAddress.isMulticastAddress()) {
            return false;
        }
        if (!(inetAddress instanceof Inet4Address)) {
            return false;
        }
        return !SshdSocketAddress.isLoopback(inetAddress);
    }

    public static boolean isLoopback(InetAddress inetAddress) {
        if (inetAddress == null) {
            return false;
        }
        if (inetAddress.isLoopbackAddress()) {
            return true;
        }
        String string = SshdSocketAddress.toAddressString(inetAddress);
        return SshdSocketAddress.isLoopback(string);
    }

    public static boolean isLoopback(String string) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        if (LOCALHOST_NAME.equals(string)) {
            return true;
        }
        return SshdSocketAddress.isIPv4LoopbackAddress(string) || SshdSocketAddress.isIPv6LoopbackAddress(string);
    }

    public static boolean isIPv4LoopbackAddress(String string) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        if (LOCALHOST_IPV4.equals(string)) {
            return true;
        }
        Object[] objectArray = GenericUtils.split(string, '.');
        if (GenericUtils.length(objectArray) != 4) {
            return false;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2;
            Object object = objectArray[i2];
            if (!SshdSocketAddress.isValidIPv4AddressComponent((CharSequence)object)) {
                return false;
            }
            if (i2 != 0 || (n2 = Integer.parseInt((String)object)) == 127) continue;
            return false;
        }
        return true;
    }

    public static boolean isIPv6LoopbackAddress(String string) {
        return IPV6_LONG_LOCALHOST.equals(string) || IPV6_SHORT_LOCALHOST.equals(string);
    }

    public static boolean isEquivalentHostName(String string, String string2, boolean bl2) {
        if (GenericUtils.safeCompare(string, string2, false) == 0) {
            return true;
        }
        if (bl2) {
            return SshdSocketAddress.isWildcardAddress(string) || SshdSocketAddress.isWildcardAddress(string2);
        }
        return false;
    }

    public static boolean isLoopbackAlias(String string, String string2) {
        return LOCALHOST_NAME.equals(string) && SshdSocketAddress.isLoopback(string2) || LOCALHOST_NAME.equals(string2) && SshdSocketAddress.isLoopback(string);
    }

    public static boolean isWildcardAddress(String string) {
        return IPV4_ANYADDR.equalsIgnoreCase(string) || IPV6_LONG_ANY_ADDRESS.equalsIgnoreCase(string) || IPV6_SHORT_ANY_ADDRESS.equalsIgnoreCase(string);
    }

    public static SshdSocketAddress toSshdSocketAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof SshdSocketAddress) {
            return (SshdSocketAddress)socketAddress;
        }
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return new SshdSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        throw new UnsupportedOperationException("Cannot convert " + socketAddress.getClass().getSimpleName() + "=" + socketAddress + " to " + SshdSocketAddress.class.getSimpleName());
    }

    public static String toAddressString(SocketAddress socketAddress) {
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getHostString();
        }
        if (socketAddress instanceof SshdSocketAddress) {
            return ((SshdSocketAddress)socketAddress).getHostName();
        }
        return socketAddress.toString();
    }

    public static int toAddressPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getPort();
        }
        if (socketAddress instanceof SshdSocketAddress) {
            return ((SshdSocketAddress)socketAddress).getPort();
        }
        return -1;
    }

    public static InetSocketAddress toInetSocketAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        if (socketAddress instanceof SshdSocketAddress) {
            return ((SshdSocketAddress)socketAddress).toInetSocketAddress();
        }
        throw new ClassCastException("Unknown remote address type: " + socketAddress);
    }

    public static String toAddressString(InetAddress inetAddress) {
        String string;
        String string2 = string = inetAddress == null ? null : inetAddress.toString();
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        return string.replaceAll(".*/", "");
    }

    public static boolean isIPv4Address(String string) {
        if (GenericUtils.isEmpty(string = GenericUtils.trimToEmpty(string))) {
            return false;
        }
        if (WELL_KNOWN_IPV4_ADDRESSES.contains(string)) {
            return true;
        }
        Object[] objectArray = GenericUtils.split(string, '.');
        if (GenericUtils.length(objectArray) != 4) {
            return false;
        }
        for (Object object : objectArray) {
            if (SshdSocketAddress.isValidIPv4AddressComponent((CharSequence)object)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrivateIPv4Address(String string) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        if (string.startsWith(PRIVATE_CLASS_A_PREFIX) || string.startsWith(PRIVATE_CLASS_C_PREFIX)) {
            return true;
        }
        if (!string.startsWith(PRIVATE_CLASS_B_PREFIX)) {
            return false;
        }
        int n2 = string.indexOf(46, PRIVATE_CLASS_B_PREFIX.length());
        if (n2 <= PRIVATE_CLASS_B_PREFIX.length()) {
            return false;
        }
        String string2 = string.substring(PRIVATE_CLASS_B_PREFIX.length(), n2);
        if (!SshdSocketAddress.isValidIPv4AddressComponent(string2)) {
            return false;
        }
        int n3 = Integer.parseInt(string2);
        return n3 >= 16 && n3 <= 31;
    }

    public static boolean isCarrierGradeNatIPv4Address(String string) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        if (!string.startsWith(CARRIER_GRADE_NAT_PREFIX)) {
            return false;
        }
        int n2 = string.indexOf(46, CARRIER_GRADE_NAT_PREFIX.length());
        if (n2 <= CARRIER_GRADE_NAT_PREFIX.length()) {
            return false;
        }
        String string2 = string.substring(CARRIER_GRADE_NAT_PREFIX.length(), n2);
        if (!SshdSocketAddress.isValidIPv4AddressComponent(string2)) {
            return false;
        }
        int n3 = Integer.parseInt(string2);
        return n3 >= 64 && n3 <= 127;
    }

    public static boolean isValidIPv4AddressComponent(CharSequence charSequence) {
        if (GenericUtils.isEmpty(charSequence) || charSequence.length() > 3) {
            return false;
        }
        char c2 = charSequence.charAt(0);
        if (c2 < '0' || c2 > '9') {
            return false;
        }
        if (!NumberUtils.isIntegerNumber(charSequence)) {
            return false;
        }
        int n2 = Integer.parseInt(charSequence.toString());
        return n2 >= 0 && n2 <= 255;
    }

    public static boolean isIPv6Address(String string) {
        int n2;
        if (GenericUtils.isEmpty(string = GenericUtils.trimToEmpty(string))) {
            return false;
        }
        if (WELL_KNOWN_IPV6_ADDRESSES.contains(string)) {
            return true;
        }
        boolean bl2 = string.contains(IPV6_SHORT_ANY_ADDRESS);
        if (bl2 && string.indexOf(IPV6_SHORT_ANY_ADDRESS) != string.lastIndexOf(IPV6_SHORT_ANY_ADDRESS)) {
            return false;
        }
        if (string.indexOf(58) == 0 && !string.startsWith(IPV6_SHORT_ANY_ADDRESS) || string.endsWith(":") && !string.endsWith(IPV6_SHORT_ANY_ADDRESS)) {
            return false;
        }
        String[] stringArray = GenericUtils.split(string, ':');
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        if (bl2) {
            if (string.endsWith(IPV6_SHORT_ANY_ADDRESS)) {
                arrayList.add("");
            } else if (string.startsWith(IPV6_SHORT_ANY_ADDRESS) && !arrayList.isEmpty()) {
                arrayList.remove(0);
            }
        }
        if ((n2 = arrayList.size()) > 8) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            String string2 = (String)arrayList.get(i2);
            int n6 = string2.indexOf(37);
            if (n6 >= 0) {
                if (i2 != n2 - 1) {
                    return false;
                }
                String string3 = string2 = n6 > 0 ? string2.substring(0, n6) : "";
            }
            if ((n5 = string2.length()) == 0) {
                if (++n4 > 1) {
                    return false;
                }
                ++n3;
                continue;
            }
            n4 = 0;
            if (i2 == n2 - 1 && string2.indexOf(46) > 0) {
                if (!SshdSocketAddress.isIPv4Address(string2)) {
                    return false;
                }
                n3 += 2;
                continue;
            }
            if (n5 > 4) {
                return false;
            }
            int n7 = 0;
            try {
                n7 = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n7 < 0 || n7 > 65535) {
                return false;
            }
            ++n3;
        }
        return n3 <= 8 && (n3 >= 8 || bl2);
    }

    public static Object findByOptionalWildcardAddress(Map map, SshdSocketAddress sshdSocketAddress) {
        Map.Entry entry = SshdSocketAddress.findMatchingOptionalWildcardEntry(map, sshdSocketAddress);
        return entry == null ? null : entry.getValue();
    }

    public static Object removeByOptionalWildcardAddress(Map map, SshdSocketAddress sshdSocketAddress) {
        Map.Entry entry = SshdSocketAddress.findMatchingOptionalWildcardEntry(map, sshdSocketAddress);
        return entry == null ? null : map.remove(entry.getKey());
    }

    public static Map.Entry findMatchingOptionalWildcardEntry(Map map, SshdSocketAddress sshdSocketAddress) {
        if (MapEntryUtils.isEmpty(map) || sshdSocketAddress == null) {
            return null;
        }
        String string = sshdSocketAddress.getHostName();
        Map.Entry entry = null;
        for (Map.Entry entry2 : map.entrySet()) {
            SshdSocketAddress sshdSocketAddress2 = (SshdSocketAddress)entry2.getKey();
            if (sshdSocketAddress2.getPort() != sshdSocketAddress.getPort()) continue;
            String string2 = sshdSocketAddress2.getHostName();
            if (string.equalsIgnoreCase(string2)) {
                return entry2;
            }
            if (!SshdSocketAddress.isEquivalentHostName(string, string2, true)) continue;
            if (entry != null) {
                throw new IllegalStateException("Multiple candidate matches for " + sshdSocketAddress + ": " + entry + ", " + entry2);
            }
            entry = entry2;
        }
        return entry;
    }
}

