/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.util.logging.Level;
import org.apache.sshd.common.util.logging.SimplifiedLog$1;

public interface SimplifiedLog {
    public static final SimplifiedLog EMPTY = new SimplifiedLog$1();

    default public boolean isErrorEnabled() {
        return this.isEnabledLevel(Level.SEVERE);
    }

    default public void error(String string) {
        this.error(string, null);
    }

    default public void error(String string, Throwable throwable) {
        this.log(Level.SEVERE, string, throwable);
    }

    default public boolean isWarnEnabled() {
        return this.isEnabledLevel(Level.WARNING);
    }

    default public void warn(String string) {
        this.warn(string, null);
    }

    default public void warn(String string, Throwable throwable) {
        this.log(Level.WARNING, string, throwable);
    }

    default public boolean isInfoEnabled() {
        return this.isEnabledLevel(Level.INFO);
    }

    default public void info(String string) {
        this.info(string, null);
    }

    default public void info(String string, Throwable throwable) {
        this.log(Level.INFO, string, throwable);
    }

    default public boolean isDebugEnabled() {
        return this.isEnabledLevel(Level.FINE);
    }

    default public void debug(String string) {
        this.debug(string, null);
    }

    default public void debug(String string, Throwable throwable) {
        this.log(Level.FINE, string, throwable);
    }

    default public boolean isTraceEnabled() {
        return this.isEnabledLevel(Level.FINER);
    }

    default public void trace(String string) {
        this.trace(string, null);
    }

    default public void trace(String string, Throwable throwable) {
        this.log(Level.FINER, string, throwable);
    }

    public boolean isEnabledLevel(Level var1);

    default public void log(Level level, Object object) {
        this.log(level, object, null);
    }

    public void log(Level var1, Object var2, Throwable var3);

    public static boolean isErrorEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.SEVERE);
    }

    public static boolean isWarnEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.WARNING);
    }

    public static boolean isInfoEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.INFO);
    }

    public static boolean isDebugEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.FINE);
    }

    public static boolean isTraceEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.FINER);
    }

    public static boolean isLoggable(Level level, Level level2) {
        if (level == null || level2 == null) {
            return false;
        }
        if (Level.OFF.equals(level) || Level.OFF.equals(level2)) {
            return false;
        }
        if (Level.ALL.equals(level2)) {
            return true;
        }
        return level.intValue() >= level2.intValue();
    }
}

