/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.logging.LoggingUtils$1;
import org.apache.sshd.common.util.logging.LoggingUtils$2;
import org.apache.sshd.common.util.logging.LoggingUtils$3;
import org.apache.sshd.common.util.logging.LoggingUtils$4;
import org.apache.sshd.common.util.logging.LoggingUtils$5;
import org.apache.sshd.common.util.logging.LoggingUtils$6;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class LoggingUtils {
    public static final Set SLF4J_LEVELS = Collections.unmodifiableSet(EnumSet.allOf(org.slf4j.event.Level.class));

    private LoggingUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static org.slf4j.event.Level slf4jLevelFromName(String string) {
        return GenericUtils.isEmpty(string) ? null : (org.slf4j.event.Level)SLF4J_LEVELS.stream().filter(level -> string.equalsIgnoreCase(level.name())).findAny().orElse(null);
    }

    public static NavigableMap generateMnemonicMap(Class clazz, String string) {
        return LoggingUtils.generateMnemonicMap(clazz, (T field) -> {
            String string2 = field.getName();
            return string2.startsWith(string);
        });
    }

    public static NavigableMap generateMnemonicMap(Class clazz, Predicate predicate) {
        Collection collection = LoggingUtils.getMnemonicFields(clazz, predicate);
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap treeMap = new TreeMap(Comparator.naturalOrder());
        for (Field field : collection) {
            String string = field.getName();
            try {
                Number number = (Number)field.get(null);
                String string2 = treeMap.put(NumberUtils.toInteger(number), string);
                if (string2 == null) continue;
            }
            catch (Exception exception) {}
        }
        return treeMap;
    }

    public static Map getAmbiguousMenmonics(Class clazz, String string) {
        return LoggingUtils.getAmbiguousMenmonics(clazz, (T field) -> {
            String string2 = field.getName();
            return string2.startsWith(string);
        });
    }

    public static Map getAmbiguousMenmonics(Class clazz, Predicate predicate) {
        Collection collection = LoggingUtils.getMnemonicFields(clazz, predicate);
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        TreeMap treeMap2 = new TreeMap(Comparator.naturalOrder());
        for (Field field : collection) {
            String string = field.getName();
            try {
                Number number = (Number)field.get(null);
                Integer n2 = NumberUtils.toInteger(number);
                ArrayList<String> arrayList = (ArrayList<String>)treeMap2.get(n2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    treeMap2.put(n2, arrayList);
                }
                arrayList.add(string);
                int n3 = arrayList.size();
                if (n3 <= 1) continue;
                treeMap.put(string, n2);
                if (n3 != 2) continue;
                treeMap.put((String)arrayList.get(0), n2);
            }
            catch (Exception exception) {}
        }
        return treeMap;
    }

    public static Collection getMnemonicFields(Class clazz, Predicate predicate) {
        return ReflectionUtils.getMatchingFields(clazz, field -> {
            int n2 = field.getModifiers();
            if (!(Modifier.isPublic(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2))) {
                return false;
            }
            Class<?> clazz = field.getType();
            if (!NumberUtils.isNumericClass(clazz)) {
                return false;
            }
            return predicate.test(field);
        });
    }

    public static SimplifiedLog wrap(Logger logger) {
        if (logger == null) {
            return SimplifiedLog.EMPTY;
        }
        return new LoggingUtils$1(logger);
    }

    public static void logMessage(Logger logger, Level level, Object object, Throwable throwable) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return;
        }
        if (Level.SEVERE.equals(level)) {
            logger.error(Objects.toString(object), throwable);
        } else if (Level.WARNING.equals(level)) {
            logger.warn(Objects.toString(object), throwable);
        } else if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            logger.info(Objects.toString(object), throwable);
        } else if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            logger.debug(Objects.toString(object), throwable);
        } else {
            logger.trace(Objects.toString(object), throwable);
        }
    }

    public static boolean isLoggable(Logger logger, Level level) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return false;
        }
        if (Level.SEVERE.equals(level)) {
            return logger.isErrorEnabled();
        }
        if (Level.WARNING.equals(level)) {
            return logger.isWarnEnabled();
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return logger.isInfoEnabled();
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return logger.isDebugEnabled();
        }
        return logger.isTraceEnabled();
    }

    public static Consumer loggingClosure(Logger logger, Level level) {
        return LoggingUtils.loggingClosure(logger, level, null);
    }

    public static Consumer loggingClosure(Logger logger, Level level, Throwable throwable) {
        Objects.requireNonNull(level, "No level provided");
        if (Level.OFF.equals(level)) {
            return LoggingUtils.nologClosure(logger);
        }
        if (Level.SEVERE.equals(level)) {
            return LoggingUtils.errorClosure(logger, throwable);
        }
        if (Level.WARNING.equals(level)) {
            return LoggingUtils.warnClosure(logger, throwable);
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return LoggingUtils.infoClosure(logger, throwable);
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return LoggingUtils.debugClosure(logger, throwable);
        }
        return LoggingUtils.traceClosure(logger, throwable);
    }

    public static Consumer nologClosure(Logger logger) {
        Objects.requireNonNull(logger, "No logger provided");
        return object -> {};
    }

    public static Consumer errorClosure(Logger logger) {
        return LoggingUtils.errorClosure(logger, null);
    }

    public static Consumer errorClosure(Logger logger, Throwable throwable) {
        Objects.requireNonNull(logger, "No logger provided");
        return new LoggingUtils$2(logger, throwable);
    }

    public static Consumer warnClosure(Logger logger) {
        return LoggingUtils.warnClosure(logger, null);
    }

    public static Consumer warnClosure(Logger logger, Throwable throwable) {
        Objects.requireNonNull(logger, "No logger provided");
        return new LoggingUtils$3(logger, throwable);
    }

    public static Consumer infoClosure(Logger logger) {
        return LoggingUtils.infoClosure(logger, null);
    }

    public static Consumer infoClosure(Logger logger, Throwable throwable) {
        Objects.requireNonNull(logger, "No logger provided");
        return new LoggingUtils$4(logger, throwable);
    }

    public static Consumer debugClosure(Logger logger) {
        return LoggingUtils.debugClosure(logger, null);
    }

    public static Consumer debugClosure(Logger logger, Throwable throwable) {
        Objects.requireNonNull(logger, "No logger provided");
        return new LoggingUtils$5(logger, throwable);
    }

    public static Consumer traceClosure(Logger logger) {
        return LoggingUtils.traceClosure(logger, null);
    }

    public static Consumer traceClosure(Logger logger, Throwable throwable) {
        Objects.requireNonNull(logger, "No logger provided");
        return new LoggingUtils$6(logger, throwable);
    }

    public static String formatMessage(String string, Object ... objectArray) {
        if (GenericUtils.isEmpty(string) || GenericUtils.isEmpty(objectArray)) {
            return string;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)string, (Object[])objectArray, null);
        return formattingTuple.getMessage();
    }

    public static void debug(Logger logger, String string, Object object, Object object2, Throwable throwable) {
        if (logger.isTraceEnabled() && throwable != null) {
            logger.debug(string, new Object[]{object, object2, throwable});
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, object, object2);
        }
    }

    public static void debug(Logger logger, String string, Object object, Object object2, Object object3, Throwable throwable) {
        if (logger.isTraceEnabled() && throwable != null) {
            logger.debug(string, new Object[]{object, object2, object3, throwable});
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, new Object[]{object, object2, object3});
        }
    }

    public static void debug(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Throwable throwable) {
        if (logger.isTraceEnabled() && throwable != null) {
            logger.debug(string, new Object[]{object, object2, object3, object4, throwable});
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, new Object[]{object, object2, object3, object4});
        }
    }

    public static void debug(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        if (logger.isTraceEnabled() && throwable != null) {
            logger.debug(string, new Object[]{object, object2, object3, object4, object5, throwable});
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, new Object[]{object, object2, object3, object4, object5});
        }
    }

    public static void debug(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        if (logger.isTraceEnabled() && throwable != null) {
            logger.debug(string, new Object[]{object, object2, object3, object4, object5, object6, throwable});
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, new Object[]{object, object2, object3, object4, object5, object6});
        }
    }

    public static void info(Logger logger, String string, Object object, Object object2, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.info(string, new Object[]{object, object2, throwable});
        } else {
            logger.info(string, object, object2);
        }
    }

    public static void info(Logger logger, String string, Object object, Object object2, Object object3, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.info(string, new Object[]{object, object2, object3, throwable});
        } else {
            logger.info(string, new Object[]{object, object2, object3});
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, throwable});
        } else {
            logger.warn(string, object, object2);
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Object object3, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, object3, throwable});
        } else {
            logger.warn(string, new Object[]{object, object2, object3});
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, object3, object4, throwable});
        } else {
            logger.warn(string, new Object[]{object, object2, object3, object4});
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, throwable});
        } else {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5});
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6, throwable});
        } else {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6});
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6, object7, throwable});
        } else {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6, object7});
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6, object7, object8, throwable});
        } else {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6, object7, object8});
        }
    }

    public static void warn(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9, throwable});
        } else {
            logger.warn(string, new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9});
        }
    }

    public static void error(Logger logger, String string, Object object, Object object2, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.error(string, new Object[]{object, object2, throwable});
        } else {
            logger.error(string, object, object2);
        }
    }

    public static void error(Logger logger, String string, Object object, Object object2, Object object3, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.error(string, new Object[]{object, object2, object3, throwable});
        } else {
            logger.error(string, new Object[]{object, object2, object3});
        }
    }

    public static void error(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.error(string, new Object[]{object, object2, object3, object4, throwable});
        } else {
            logger.error(string, new Object[]{object, object2, object3, object4});
        }
    }

    public static void error(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.error(string, new Object[]{object, object2, object3, object4, object5, throwable});
        } else {
            logger.error(string, new Object[]{object, object2, object3, object4, object5});
        }
    }

    public static void error(Logger logger, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        if (logger.isDebugEnabled() && throwable != null) {
            logger.error(string, new Object[]{object, object2, object3, object4, object5, object6, throwable});
        } else {
            logger.error(string, new Object[]{object, object2, object3, object4, object5, object6});
        }
    }
}

