/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingBean {
    protected final Logger log;
    private final AtomicReference simplifiedLog = new AtomicReference();

    protected AbstractLoggingBean() {
        this((Logger)null);
    }

    protected AbstractLoggingBean(String string) {
        String string2 = this.getClass().getName();
        if (GenericUtils.isNotEmpty(string)) {
            string2 = string2 + "[" + string + "]";
        }
        this.log = LoggerFactory.getLogger((String)string2);
    }

    protected AbstractLoggingBean(Logger logger) {
        this.log = logger == null ? LoggerFactory.getLogger(this.getClass()) : logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimplifiedLog getSimplifiedLogger() {
        SimplifiedLog simplifiedLog;
        AtomicReference atomicReference = this.simplifiedLog;
        synchronized (atomicReference) {
            simplifiedLog = (SimplifiedLog)this.simplifiedLog.get();
            if (simplifiedLog == null) {
                simplifiedLog = LoggingUtils.wrap(this.log);
            }
        }
        return simplifiedLog;
    }

    protected void debug(String string, Object object, Object object2, Throwable throwable) {
        LoggingUtils.debug(this.log, string, object, object2, throwable);
    }

    protected void debug(String string, Object object, Object object2, Object object3, Throwable throwable) {
        LoggingUtils.debug(this.log, string, object, object2, object3, throwable);
    }

    protected void debug(String string, Object object, Object object2, Object object3, Object object4, Throwable throwable) {
        LoggingUtils.debug(this.log, string, object, object2, object3, object4, throwable);
    }

    protected void debug(String string, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        LoggingUtils.debug(this.log, string, object, object2, object3, object4, object5, throwable);
    }

    protected void debug(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        LoggingUtils.debug(this.log, string, object, object2, object3, object4, object5, object6, throwable);
    }

    protected void info(String string, Object object, Object object2, Throwable throwable) {
        LoggingUtils.info(this.log, string, object, object2, throwable);
    }

    protected void info(String string, Object object, Object object2, Object object3, Throwable throwable) {
        LoggingUtils.info(this.log, string, object, object2, object3, throwable);
    }

    protected void warn(String string, Object object, Object object2, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, throwable);
    }

    protected void warn(String string, Object object, Object object2, Object object3, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, object3, throwable);
    }

    protected void warn(String string, Object object, Object object2, Object object3, Object object4, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, object3, object4, throwable);
    }

    protected void warn(String string, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, object3, object4, object5, throwable);
    }

    protected void warn(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, object3, object4, object5, object6, throwable);
    }

    protected void warn(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, object3, object4, object5, object6, object7, throwable);
    }

    protected void warn(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, object3, object4, object5, object6, object7, object8, throwable);
    }

    protected void warn(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Throwable throwable) {
        LoggingUtils.warn(this.log, string, object, object2, object3, object4, object5, object6, object7, object8, object9, throwable);
    }

    protected void error(String string, Object object, Object object2, Throwable throwable) {
        LoggingUtils.error(this.log, string, object, object2, throwable);
    }

    protected void error(String string, Object object, Object object2, Object object3, Throwable throwable) {
        LoggingUtils.error(this.log, string, object, object2, object3, throwable);
    }

    protected void error(String string, Object object, Object object2, Object object3, Object object4, Throwable throwable) {
        LoggingUtils.error(this.log, string, object, object2, object3, object4, throwable);
    }

    protected void error(String string, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        LoggingUtils.error(this.log, string, object, object2, object3, object4, object5, throwable);
    }

    protected void error(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        LoggingUtils.error(this.log, string, object, object2, object3, object4, object5, object6, throwable);
    }
}

