/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.resource;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.AbstractIoResource;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class ClassLoaderResource
extends AbstractIoResource {
    private final String resourceName;

    public ClassLoaderResource(ClassLoader classLoader, String string) {
        super(ClassLoader.class, classLoader == null ? ThreadUtils.resolveDefaultClassLoader(ClassLoaderResource.class) : classLoader);
        this.resourceName = ValidateUtils.checkNotNullAndNotEmpty(string, "No resource name provided");
    }

    public ClassLoader getResourceLoader() {
        return (ClassLoader)this.getResourceValue();
    }

    @Override
    public String getName() {
        return this.resourceName;
    }

    @Override
    public InputStream openInputStream() {
        String string = this.getName();
        ClassLoader classLoader = this.getResourceLoader();
        if (classLoader == null) {
            throw new StreamCorruptedException("No resource loader for " + string);
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException("Cannot find resource " + string);
        }
        return inputStream;
    }
}

