/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.EOFException;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;

public class NullOutputStream
extends OutputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void write(int n2) {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for writing one byte");
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for writing " + n3 + " bytes");
        }
    }

    @Override
    public void flush() {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for flushing");
        }
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

