/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;

public class LoggingFilterOutputStream
extends FilterOutputStream {
    private final String msg;
    private final SimplifiedLog log;
    private final int chunkSize;
    private final AtomicInteger writeCount = new AtomicInteger(0);

    public LoggingFilterOutputStream(OutputStream outputStream, String string, Logger logger, PropertyResolver propertyResolver) {
        this(outputStream, string, logger, (Integer)CommonModuleProperties.HEXDUMP_CHUNK_SIZE.getRequired(propertyResolver));
    }

    public LoggingFilterOutputStream(OutputStream outputStream, String string, Logger logger, int n2) {
        super(outputStream);
        this.msg = string;
        this.log = LoggingUtils.wrap(logger);
        this.chunkSize = n2;
    }

    @Override
    public void write(int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4 = this.writeCount.incrementAndGet();
        BufferUtils.dumpHex(this.log, BufferUtils.DEFAULT_HEXDUMP_LEVEL, this.msg + "[" + n4 + "]", ' ', this.chunkSize, byArray, n2, n3);
        this.out.write(byArray, n2, n3);
    }
}

