/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.OutputStream;

public abstract class LineOutputStream
extends OutputStream {
    protected final byte[] oneByte = new byte[1];
    protected byte[] lineBuf;
    protected int usedLen;

    protected LineOutputStream() {
    }

    @Override
    public void write(int n2) {
        this.oneByte[0] = (byte)(n2 & 0xFF);
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            byte by = byArray[i2];
            if (by != 10) continue;
            if (this.usedLen > 0) {
                this.accumulateLineData(byArray, n4, i2 - n4);
                if (this.lineBuf[this.usedLen - 1] == 13) {
                    --this.usedLen;
                }
                this.handleLine(this.lineBuf, 0, this.usedLen);
                this.usedLen = 0;
            } else {
                int n6 = i2 - n4;
                if (n6 > 0 && byArray[i2 - 1] == 13) {
                    --n6;
                }
                this.handleLine(byArray, n4, n6);
            }
            n4 = i2 + 1;
        }
        if (n4 < n5) {
            this.accumulateLineData(byArray, n4, n5 - n4);
        }
    }

    protected void accumulateLineData(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        int n4 = this.usedLen + n3;
        if (this.lineBuf == null || n4 >= this.lineBuf.length) {
            byte[] byArray2 = new byte[n4 + 8];
            if (this.usedLen > 0) {
                System.arraycopy(this.lineBuf, 0, byArray2, 0, this.usedLen);
            }
            this.lineBuf = byArray2;
        }
        System.arraycopy(byArray, n2, this.lineBuf, this.usedLen, n3);
        this.usedLen += n3;
    }

    protected abstract void handleLine(byte[] var1, int var2, int var3);

    @Override
    public void close() {
        if (this.usedLen > 0) {
            if (this.lineBuf[this.usedLen - 1] == 13) {
                --this.usedLen;
            }
            this.handleLine(this.lineBuf, 0, this.usedLen);
            this.usedLen = 0;
        }
    }
}

