/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.output.LineLevelAppender;
import org.apache.sshd.common.util.io.output.LineOutputStream;

public class LineLevelAppenderStream
extends LineOutputStream {
    protected final CharsetDecoder csDecoder;
    protected final LineLevelAppender appenderInstance;
    protected char[] lineBuf;

    public LineLevelAppenderStream(LineLevelAppender lineLevelAppender) {
        this(Charset.defaultCharset(), lineLevelAppender);
    }

    public LineLevelAppenderStream(String string, LineLevelAppender lineLevelAppender) {
        this(Charset.forName(ValidateUtils.checkNotNullAndNotEmpty(string, "No charset name")), lineLevelAppender);
    }

    public LineLevelAppenderStream(Charset charset, LineLevelAppender lineLevelAppender) {
        this(Objects.requireNonNull(charset, "No charset").newDecoder(), lineLevelAppender);
    }

    public LineLevelAppenderStream(CharsetDecoder charsetDecoder, LineLevelAppender lineLevelAppender) {
        this.csDecoder = Objects.requireNonNull(charsetDecoder, "No decoder");
        this.appenderInstance = Objects.requireNonNull(lineLevelAppender, "No appender");
    }

    public final LineLevelAppender getLineLevelAppender() {
        return this.appenderInstance;
    }

    @Override
    protected void handleLine(byte[] byArray, int n2, int n3) {
        LineLevelAppender lineLevelAppender = this.getLineLevelAppender();
        if (n3 <= 0) {
            lineLevelAppender.writeLineData("");
            return;
        }
        ByteBuffer byteBuffer = byArray[n2 + n3 - 1] == 13 ? ByteBuffer.wrap(byArray, n2, n3 - 1) : ByteBuffer.wrap(byArray, n2, n3);
        char[] cArray = this.ensureCharDataCapacity(n3);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        this.csDecoder.reset();
        CoderResult coderResult = this.csDecoder.decode(byteBuffer, charBuffer, true);
        if (coderResult.isError() || coderResult.isMalformed() || coderResult.isOverflow() || coderResult.isUnmappable()) {
            throw new StreamCorruptedException("Failed to decode line bytes: " + coderResult);
        }
        charBuffer.flip();
        lineLevelAppender.writeLineData(charBuffer);
    }

    protected char[] ensureCharDataCapacity(int n2) {
        int n3;
        float f2 = this.csDecoder.maxCharsPerByte();
        int n4 = n3 = f2 > 0.0f ? (int)((float)n2 * f2) : n2;
        if (this.lineBuf == null || this.lineBuf.length < n3) {
            n3 = Math.max(n3, 80);
            this.lineBuf = new char[n3 + 8];
        }
        return this.lineBuf;
    }
}

