/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.input;

import java.io.EOFException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;

public class NullInputStream
extends InputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public int read() {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for reading one value");
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for reading " + n3 + " bytes");
        }
        return -1;
    }

    @Override
    public long skip(long l2) {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for skipping " + l2 + " bytes");
        }
        return 0L;
    }

    @Override
    public int available() {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for availability query");
        }
        return 0;
    }

    @Override
    public synchronized void reset() {
        if (!this.isOpen()) {
            throw new EOFException("Stream is closed for reset");
        }
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

