/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;

public class LimitInputStream
extends FilterInputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private long remaining;

    public LimitInputStream(InputStream inputStream, long l2) {
        super(inputStream);
        this.remaining = l2;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public int read() {
        if (!this.isOpen()) {
            throw new IOException("read() - stream is closed (remaining=" + this.remaining + ")");
        }
        if (this.remaining > 0L) {
            --this.remaining;
            return super.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (!this.isOpen()) {
            throw new IOException("read(len=" + n3 + ") stream is closed (remaining=" + this.remaining + ")");
        }
        int n4 = n3;
        if ((long)n4 > this.remaining) {
            n4 = (int)this.remaining;
        }
        if (n4 > 0) {
            int n5 = super.read(byArray, n2, n4);
            this.remaining -= (long)n5;
            return n5;
        }
        return -1;
    }

    @Override
    public long skip(long l2) {
        if (!this.isOpen()) {
            throw new IOException("skip(" + l2 + ") stream is closed (remaining=" + this.remaining + ")");
        }
        long l3 = super.skip(l2);
        this.remaining -= l3;
        return l3;
    }

    @Override
    public int available() {
        if (!this.isOpen()) {
            throw new IOException("available() stream is closed (remaining=" + this.remaining + ")");
        }
        int n2 = super.available();
        if ((long)n2 > this.remaining) {
            return (int)this.remaining;
        }
        return n2;
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

