/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.input;

import java.io.IOException;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.util.io.input.EmptyInputStream;

public class CloseableEmptyInputStream
extends EmptyInputStream
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public int available() {
        if (this.isOpen()) {
            return super.available();
        }
        throw new IOException("available() stream is closed");
    }

    @Override
    public int read() {
        if (this.isOpen()) {
            return super.read();
        }
        throw new IOException("read() stream is closed");
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.isOpen()) {
            return super.read(byArray, n2, n3);
        }
        throw new IOException("read([])[" + n2 + "," + n3 + "] stream is closed");
    }

    @Override
    public long skip(long l2) {
        if (this.isOpen()) {
            return super.skip(l2);
        }
        throw new IOException("skip(" + l2 + ") stream is closed");
    }

    @Override
    public synchronized void reset() {
        if (!this.isOpen()) {
            throw new IOException("reset() stream is closed");
        }
        super.reset();
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            return;
        }
    }
}

