/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.functors;

import java.util.AbstractMap;
import java.util.Collection;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface Invoker {
    public Object invoke(Object var1);

    public static Invoker wrapAll(Collection collection) {
        return object -> {
            Invoker.invokeAll(object, collection);
            return null;
        };
    }

    public static void invokeAll(Object object, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return;
        }
        Throwable throwable = null;
        for (Invoker invoker : collection) {
            if (invoker == null) continue;
            try {
                invoker.invoke(object);
            }
            catch (Throwable throwable2) {
                throwable = ExceptionUtils.accumulateException(throwable, throwable2);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static Invoker wrapFirst(Collection collection) {
        return object -> {
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = Invoker.invokeTillFirstFailure(object, collection);
            if (simpleImmutableEntry != null) {
                throw (Throwable)simpleImmutableEntry.getValue();
            }
            return null;
        };
    }

    public static AbstractMap.SimpleImmutableEntry invokeTillFirstFailure(Object object, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return null;
        }
        for (Invoker invoker : collection) {
            if (invoker == null) continue;
            try {
                invoker.invoke(object);
            }
            catch (Throwable throwable) {
                return new AbstractMap.SimpleImmutableEntry<Invoker, Throwable>(invoker, throwable);
            }
        }
        return null;
    }
}

