/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.der.ASN1Class;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERWriter$1;

public class DERWriter
extends FilterOutputStream {
    private final byte[] lenBytes = new byte[4];

    public DERWriter() {
        this(256);
    }

    public DERWriter(int n2) {
        this(new ByteArrayOutputStream(n2));
    }

    public DERWriter(OutputStream outputStream) {
        super(Objects.requireNonNull(outputStream, "No output stream"));
    }

    public DERWriter startSequence() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        DERWriter dERWriter = this;
        return new DERWriter$1(this, byteArrayOutputStream, byteArrayOutputStream, atomicBoolean, dERWriter);
    }

    public void writeBigInteger(BigInteger bigInteger) {
        this.writeBigInteger(Objects.requireNonNull(bigInteger, "No value").toByteArray());
    }

    public void writeBigInteger(byte ... byArray) {
        this.writeBigInteger(byArray, 0, NumberUtils.length(byArray));
    }

    public void writeBigInteger(byte[] byArray, int n2, int n3) {
        while (n3 > 1 && byArray[n2] == 0 && this.isPositive(byArray[n2 + 1])) {
            ++n2;
            --n3;
        }
        this.write(2);
        if (this.isPositive(byArray[n2])) {
            this.writeLength(n3);
        } else {
            this.writeLength(n3 + 1);
            this.write(0);
        }
        this.write(byArray, n2, n3);
    }

    private boolean isPositive(byte by) {
        return (by & 0x80) == 0;
    }

    public void writeObject(ASN1Object aSN1Object) {
        Objects.requireNonNull(aSN1Object, "No ASN.1 object");
        ASN1Type aSN1Type = aSN1Object.getObjType();
        byte by = aSN1Type.getTypeValue();
        ASN1Class aSN1Class = aSN1Object.getObjClass();
        byte by2 = aSN1Class.getClassValue();
        byte by3 = (byte)(by2 << 6 & 0xC0 | by & 0x1F);
        this.writeObject(by3, aSN1Object.getLength(), aSN1Object.getValue());
    }

    public void writeObject(byte by, int n2, byte ... byArray) {
        this.write(by & 0xFF);
        this.writeLength(n2);
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
    }

    public void writeLength(int n2) {
        int n3;
        ValidateUtils.checkTrue(n2 >= 0, "Invalid length: %d", n2);
        if (n2 <= 127) {
            this.write(n2);
            return;
        }
        BufferUtils.putUInt(n2, this.lenBytes);
        for (n3 = 0; n3 < this.lenBytes.length && this.lenBytes[n3] == 0; ++n3) {
        }
        if (n3 >= this.lenBytes.length) {
            throw new StreamCorruptedException("All zeroes length representation for len=" + n2);
        }
        int n4 = this.lenBytes.length - n3;
        this.write(0x80 | n4);
        this.write(this.lenBytes, n3, n4);
    }

    public byte[] toByteArray() {
        if (this.out instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
        throw new IOException("The underlying stream is not a byte[] stream");
    }
}

