/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.der.ASN1Object;
import org.apache.sshd.common.util.io.der.ASN1Type;

public class DERParser
extends FilterInputStream {
    public static final int MAX_DER_VALUE_LENGTH = 65534;
    private final byte[] lenBytes = new byte[4];

    public DERParser(byte ... byArray) {
        this(byArray, 0, NumberUtils.length(byArray));
    }

    public DERParser(byte[] byArray, int n2, int n3) {
        this(new ByteArrayInputStream(byArray, n2, n3));
    }

    public DERParser(InputStream inputStream) {
        super(inputStream);
    }

    public int readLength() {
        int n2 = this.read();
        if (n2 == -1) {
            throw new StreamCorruptedException("Invalid DER: length missing");
        }
        if ((n2 & 0xFFFFFF80) == 0) {
            return n2;
        }
        int n3 = n2 & 0x7F;
        if (n2 >= 255 || n3 > this.lenBytes.length) {
            throw new StreamCorruptedException("Invalid DER: length field too big: " + n2);
        }
        Arrays.fill(this.lenBytes, (byte)0);
        int n4 = this.read(this.lenBytes, 4 - n3, n3);
        if (n4 < n3) {
            throw new StreamCorruptedException("Invalid DER: length data too short: expected=" + n3 + ", actual=" + n4);
        }
        long l2 = BufferUtils.getUInt(this.lenBytes);
        if (l2 < 127L) {
            throw new StreamCorruptedException("Invalid DER: length not in shortest form: " + l2);
        }
        if (l2 > 65534L) {
            throw new StreamCorruptedException("Invalid DER: data length too big: " + l2 + " (max=" + 65534 + ")");
        }
        return (int)l2;
    }

    public ASN1Object readObject() {
        int n2 = this.read();
        if (n2 == -1) {
            return null;
        }
        ASN1Type aSN1Type = ASN1Type.fromDERValue(n2);
        if (aSN1Type == ASN1Type.NULL) {
            return new ASN1Object((byte)n2, 0, GenericUtils.EMPTY_BYTE_ARRAY);
        }
        int n3 = this.readLength();
        byte[] byArray = new byte[n3];
        int n4 = this.read(byArray);
        if (n4 < n3) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n4 + " out of required " + n3);
        }
        return new ASN1Object((byte)n2, n3, byArray);
    }

    public BigInteger readBigInteger() {
        int n2 = this.read();
        if (n2 != 2) {
            throw new StreamCorruptedException("Invalid DER: data type is not an INTEGER: 0x" + Integer.toHexString(n2));
        }
        int n3 = this.readLength();
        byte[] byArray = new byte[n3];
        int n4 = this.read(byArray);
        if (n4 < n3) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n4 + " out of required " + n3);
        }
        return new BigInteger(byArray);
    }
}

