/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;

public enum ASN1Type {
    ANY(0),
    BOOLEAN(1),
    INTEGER(2),
    BIT_STRING(3),
    OCTET_STRING(4),
    NULL(5),
    OBJECT_IDENTIFIER(6),
    REAL(9),
    ENUMERATED(10),
    RELATIVE_OID(13),
    SEQUENCE(16),
    SET(17),
    NUMERIC_STRING(18),
    PRINTABLE_STRING(19),
    T61_STRING(20),
    VIDEOTEX_STRING(21),
    IA5_STRING(22),
    GRAPHIC_STRING(25),
    ISO646_STRING(26),
    GENERAL_STRING(27),
    UTF8_STRING(12),
    UNIVERSAL_STRING(28),
    BMP_STRING(30),
    UTC_TIME(23),
    GENERALIZED_TIME(24);

    public static final Set VALUES;
    private final byte typeValue;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ASN1Type() {
        void var3_2;
        this.typeValue = var3_2;
    }

    public byte getTypeValue() {
        return this.typeValue;
    }

    public static ASN1Type fromName(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (ASN1Type aSN1Type : VALUES) {
            if (!string.equalsIgnoreCase(aSN1Type.name())) continue;
            return aSN1Type;
        }
        return null;
    }

    public static ASN1Type fromDERValue(int n2) {
        return ASN1Type.fromTypeValue(n2 & 0x1F);
    }

    public static ASN1Type fromTypeValue(int n2) {
        if (n2 < 0 || n2 > 31) {
            return null;
        }
        for (ASN1Type aSN1Type : VALUES) {
            if (aSN1Type.getTypeValue() != n2) continue;
            return aSN1Type;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(ASN1Type.class));
    }
}

