/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.der.ASN1Class;
import org.apache.sshd.common.util.io.der.ASN1Type;
import org.apache.sshd.common.util.io.der.DERParser;

public class ASN1Object
implements Serializable,
Cloneable {
    public static final byte CONSTRUCTED = 32;
    private static final long serialVersionUID = 4687581744706127265L;
    private ASN1Class objClass;
    private ASN1Type objType;
    private boolean constructed;
    private int length;
    private byte[] value;

    public ASN1Object() {
    }

    public ASN1Object(byte by, int n2, byte ... byArray) {
        this(ASN1Class.fromDERValue(by), ASN1Type.fromDERValue(by), (by & 0x20) == 32, n2, byArray);
    }

    public ASN1Object(ASN1Class aSN1Class, ASN1Type aSN1Type, boolean bl2, int n2, byte ... byArray) {
        this.objClass = aSN1Class;
        this.objType = aSN1Type;
        this.constructed = bl2;
        this.length = n2;
        this.value = byArray;
    }

    public ASN1Class getObjClass() {
        return this.objClass;
    }

    public void setObjClass(ASN1Class aSN1Class) {
        this.objClass = aSN1Class;
    }

    public ASN1Type getObjType() {
        return this.objType;
    }

    public void setObjType(ASN1Type aSN1Type) {
        this.objType = aSN1Type;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public void setConstructed(boolean bl2) {
        this.constructed = bl2;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n2) {
        this.length = n2;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getPureValueBytes() {
        byte[] byArray = this.getValue();
        int n2 = this.getLength();
        int n3 = NumberUtils.length(byArray);
        if (n3 == n2) {
            return byArray;
        }
        if (n2 == 0) {
            return GenericUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public void setValue(byte[] byArray) {
        this.value = byArray;
    }

    public DERParser createParser() {
        return new DERParser(this.getValue(), 0, this.getLength());
    }

    public Object asObject() {
        ASN1Type aSN1Type = this.getObjType();
        if (aSN1Type == null) {
            throw new IOException("No type set");
        }
        switch (aSN1Type) {
            case INTEGER: {
                return this.asInteger();
            }
            case NUMERIC_STRING: 
            case PRINTABLE_STRING: 
            case VIDEOTEX_STRING: 
            case IA5_STRING: 
            case GRAPHIC_STRING: 
            case ISO646_STRING: 
            case GENERAL_STRING: 
            case BMP_STRING: 
            case UTF8_STRING: {
                return this.asString();
            }
            case OBJECT_IDENTIFIER: {
                return this.asOID();
            }
            case SEQUENCE: {
                return this.getValue();
            }
        }
        throw new IOException("Invalid DER: unsupported type: " + (Object)((Object)aSN1Type));
    }

    public BigInteger asInteger() {
        ASN1Type aSN1Type = this.getObjType();
        if (ASN1Type.INTEGER.equals((Object)aSN1Type)) {
            return this.toInteger();
        }
        throw new IOException("Invalid DER: object is not integer: " + (Object)((Object)aSN1Type));
    }

    public BigInteger toInteger() {
        return new BigInteger(this.getPureValueBytes());
    }

    public String asString() {
        String string;
        ASN1Type aSN1Type = this.getObjType();
        if (aSN1Type == null) {
            throw new IOException("No type set");
        }
        switch (aSN1Type) {
            case NUMERIC_STRING: 
            case PRINTABLE_STRING: 
            case VIDEOTEX_STRING: 
            case IA5_STRING: 
            case GRAPHIC_STRING: 
            case ISO646_STRING: 
            case GENERAL_STRING: {
                string = "ISO-8859-1";
                break;
            }
            case BMP_STRING: {
                string = "UTF-16BE";
                break;
            }
            case UTF8_STRING: {
                string = "UTF-8";
                break;
            }
            case UNIVERSAL_STRING: {
                throw new IOException("Invalid DER: can't handle UCS-4 string");
            }
            default: {
                throw new IOException("Invalid DER: object is not a string: " + (Object)((Object)aSN1Type));
            }
        }
        return new String(this.getValue(), 0, this.getLength(), string);
    }

    public List asOID() {
        ASN1Type aSN1Type = this.getObjType();
        if (ASN1Type.OBJECT_IDENTIFIER.equals((Object)aSN1Type)) {
            return this.toOID();
        }
        throw new StreamCorruptedException("Invalid DER: object is not an OID: " + (Object)((Object)aSN1Type));
    }

    public List toOID() {
        int n2 = this.getLength();
        if (n2 <= 0) {
            throw new EOFException("Not enough data for an OID");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 + 1);
        byte[] byArray = this.getValue();
        int n3 = byArray[0] & 0xFF;
        arrayList.add(n3 / 40);
        arrayList.add(n3 % 40);
        for (int i2 = 1; i2 < n2; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            if (n4 <= 127) {
                arrayList.add(n4);
                continue;
            }
            long l2 = n4 & 0x7F;
            ++i2;
            int n5 = 1;
            while (true) {
                if (i2 >= n2) {
                    throw new EOFException("Incomplete OID value");
                }
                if (n5 > 5) {
                    throw new StreamCorruptedException("OID component encoding beyond 5 bytes");
                }
                n4 = byArray[i2] & 0xFF;
                if ((l2 = l2 << 7 & 0xFFFFFFFF80L | (long)n4 & 0x7FL) > Integer.MAX_VALUE) {
                    throw new StreamCorruptedException("OID value exceeds 32 bits: " + l2);
                }
                if (n4 <= 127) break;
                ++n5;
                ++i2;
            }
            arrayList.add((int)(l2 & Integer.MAX_VALUE));
        }
        return arrayList;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getObjClass(), this.getObjType()}) + Boolean.hashCode(this.isConstructed()) + this.getLength() + NumberUtils.hashCode(this.getValue(), 0, this.getLength());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ASN1Object aSN1Object = (ASN1Object)object;
        return Objects.equals((Object)this.getObjClass(), (Object)aSN1Object.getObjClass()) && Objects.equals((Object)this.getObjType(), (Object)aSN1Object.getObjType()) && this.isConstructed() == aSN1Object.isConstructed() && this.getLength() == aSN1Object.getLength() && NumberUtils.diffOffset(this.getValue(), 0, aSN1Object.getValue(), 0, this.getLength()) < 0;
    }

    public ASN1Object clone() {
        try {
            ASN1Object aSN1Object = (ASN1Object)this.getClass().cast(super.clone());
            byte[] byArray = aSN1Object.getValue();
            if (byArray != null) {
                aSN1Object.setValue((byte[])byArray.clone());
            }
            return aSN1Object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException("Unexpected clone failure: " + cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
    }

    public String toString() {
        return Objects.toString((Object)this.getObjClass()) + "/" + (Object)((Object)this.getObjType()) + "/" + this.isConstructed() + "[" + this.getLength() + "]: " + BufferUtils.toHex(this.getValue(), 0, this.getLength(), ':');
    }
}

