/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;

public enum ASN1Class {
    UNIVERSAL(0),
    APPLICATION(1),
    CONTEXT(2),
    PRIVATE(3);

    public static final List VALUES;
    private final byte byteValue;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ASN1Class() {
        void var3_2;
        this.byteValue = var3_2;
    }

    public byte getClassValue() {
        return this.byteValue;
    }

    public static ASN1Class fromName(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (ASN1Class aSN1Class : VALUES) {
            if (!string.equalsIgnoreCase(aSN1Class.name())) continue;
            return aSN1Class;
        }
        return null;
    }

    public static ASN1Class fromDERValue(int n2) {
        return ASN1Class.fromTypeValue(n2 >> 6 & 3);
    }

    public static ASN1Class fromTypeValue(int n2) {
        if (n2 < 0 || n2 >= VALUES.size()) {
            return null;
        }
        return (ASN1Class)((Object)VALUES.get(n2));
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(ASN1Class.values()));
    }
}

