/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.functors.UnaryEquator;
import org.apache.sshd.common.util.io.PathUtils$LazyDefaultUserHomeFolderHolder;

public final class PathUtils {
    public static final Comparator BY_CASE_INSENSITIVE_FILENAME = (path, path2) -> PathUtils.safeCompareFilename(path, path2, false);
    public static final UnaryEquator EQ_CASE_INSENSITIVE_FILENAME = (path, path2) -> BY_CASE_INSENSITIVE_FILENAME.compare(path, path2) == 0;
    public static final Comparator BY_CASE_SENSITIVE_FILENAME = (path, path2) -> PathUtils.safeCompareFilename(path, path2, true);
    public static final UnaryEquator EQ_CASE_SENSITIVE_FILENAME = (path, path2) -> BY_CASE_SENSITIVE_FILENAME.compare(path, path2) == 0;
    public static final char HOME_TILDE_CHAR = '~';
    private static final AtomicReference USER_HOME_RESOLVER_HOLDER = new AtomicReference();

    private PathUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static int safeCompareFilename(Path path, Path path2, boolean bl2) {
        if (UnaryEquator.isSameReference(path, path2)) {
            return 0;
        }
        if (path == null) {
            return 1;
        }
        if (path2 == null) {
            return -1;
        }
        String string = Objects.toString(path.getFileName(), null);
        String string2 = Objects.toString(path2.getFileName(), null);
        return GenericUtils.safeCompare(string, string2, bl2);
    }

    public static String normalizePath(String string) {
        if (GenericUtils.isBlank(string)) {
            return string;
        }
        if (string.charAt(0) == '~') {
            Path path = Objects.requireNonNull(PathUtils.getUserHomeFolder(), "No user home folder available");
            string = string.length() > 1 ? path + string.substring(1) : path.toString();
        }
        return string.replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getUserHomeFolder() {
        Supplier supplier;
        AtomicReference atomicReference = USER_HOME_RESOLVER_HOLDER;
        synchronized (atomicReference) {
            supplier = (Supplier)USER_HOME_RESOLVER_HOLDER.get();
        }
        return supplier == null ? PathUtils$LazyDefaultUserHomeFolderHolder.access$000() : (Path)supplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserHomeFolderResolver(Supplier supplier) {
        AtomicReference atomicReference = USER_HOME_RESOLVER_HOLDER;
        synchronized (atomicReference) {
            USER_HOME_RESOLVER_HOLDER.set(supplier);
        }
    }

    public static StringBuilder appendUserHome(StringBuilder stringBuilder) {
        return PathUtils.appendUserHome(stringBuilder, PathUtils.getUserHomeFolder());
    }

    public static StringBuilder appendUserHome(StringBuilder stringBuilder, Path path) {
        return PathUtils.appendUserHome(stringBuilder, Objects.requireNonNull(path, "No user home folder").toString());
    }

    public static StringBuilder appendUserHome(StringBuilder stringBuilder, String string) {
        if (GenericUtils.isEmpty(string)) {
            return stringBuilder;
        }
        stringBuilder.append(string);
        int n2 = stringBuilder.length();
        if (stringBuilder.charAt(n2 - 1) == File.separatorChar) {
            stringBuilder.setLength(n2 - 1);
        }
        return stringBuilder;
    }
}

