/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class PathScanningMatcher {
    protected boolean caseSensitive = OsUtils.isUNIX();
    protected String separator = File.separator;
    protected List includePatterns;

    protected PathScanningMatcher() {
    }

    public void setIncludes(String ... stringArray) {
        this.setIncludes(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public List getIncludes() {
        return this.includePatterns;
    }

    public void setIncludes(Collection collection) {
        this.includePatterns = GenericUtils.isEmpty(collection) ? Collections.emptyList() : Collections.unmodifiableList(collection.stream().map(PathScanningMatcher::normalizePattern).collect(Collectors.toCollection(() -> new ArrayList(collection.size()))));
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl2) {
        this.caseSensitive = bl2;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = ValidateUtils.checkNotNullAndNotEmpty(string, "No separator provided");
    }

    protected boolean isIncluded(String string) {
        List list = this.getIncludes();
        if (GenericUtils.isEmpty(list)) {
            return false;
        }
        boolean bl2 = this.isCaseSensitive();
        String string2 = this.getSeparator();
        for (String string3 : list) {
            if (!SelectorUtils.matchPath(string3, string, string2, bl2)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String string) {
        List list = this.getIncludes();
        if (GenericUtils.isEmpty(list)) {
            return false;
        }
        boolean bl2 = this.isCaseSensitive();
        String string2 = this.getSeparator();
        for (String string3 : list) {
            if (!SelectorUtils.matchPatternStart(string3, string, string2, bl2)) continue;
            return true;
        }
        return false;
    }

    public static String normalizePattern(String string) {
        if ((string = string.trim()).startsWith("%regex[")) {
            string = File.separatorChar == '\\' ? GenericUtils.replace(string, "/", "\\\\", -1) : GenericUtils.replace(string, "\\\\", "/", -1);
        } else if ((string = string.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            string = string + "**";
        }
        return string;
    }
}

