/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.io.FileSnapshot;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ModifiableFileWatcher
extends AbstractLoggingBean {
    public static final Set STRICTLY_PROHIBITED_FILE_PERMISSION = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE));
    protected final LinkOption[] options;
    private final Path file;
    private final AtomicReference metadata = new AtomicReference();

    public ModifiableFileWatcher(Path path) {
        this(path, IoUtils.getLinkOptions(true));
    }

    public ModifiableFileWatcher(Path path, LinkOption ... linkOptionArray) {
        this.file = Objects.requireNonNull(path, "No path to watch");
        this.options = linkOptionArray == null ? IoUtils.EMPTY_LINK_OPTIONS : (LinkOption[])linkOptionArray.clone();
    }

    public final Path getPath() {
        return this.file;
    }

    public final boolean exists() {
        return Files.exists(this.getPath(), this.options);
    }

    public final long size() {
        if (this.exists()) {
            return Files.size(this.getPath());
        }
        return -1L;
    }

    public final FileTime lastModified() {
        if (this.exists()) {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(this.getPath(), BasicFileAttributes.class, this.options);
            return basicFileAttributes.lastModifiedTime();
        }
        return null;
    }

    public boolean checkReloadRequired() {
        FileSnapshot fileSnapshot = (FileSnapshot)this.metadata.get();
        if (fileSnapshot == null) {
            this.metadata.set(FileSnapshot.save(this.file, this.options));
            return true;
        }
        FileSnapshot fileSnapshot2 = fileSnapshot.reload(this.file, this.options);
        this.metadata.set(fileSnapshot2);
        return fileSnapshot != fileSnapshot2;
    }

    public void resetReloadAttributes() {
        this.metadata.set(FileSnapshot.NO_FILE);
    }

    public void updateReloadAttributes() {
        if (this.exists()) {
            this.metadata.compareAndSet(null, FileSnapshot.save(this.file, this.options));
        } else {
            this.resetReloadAttributes();
        }
    }

    public PathResource toPathResource() {
        return this.toPathResource(IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public PathResource toPathResource(OpenOption ... openOptionArray) {
        return new PathResource(this.getPath(), openOptionArray);
    }

    public String toString() {
        return Objects.toString(this.getPath());
    }

    public static AbstractMap.SimpleImmutableEntry validateStrictConfigFilePermissions(Path path, LinkOption ... linkOptionArray) {
        Object object;
        if (path == null || !Files.exists(path, linkOptionArray)) {
            return null;
        }
        Set set = IoUtils.getPermissions(path, linkOptionArray);
        if (GenericUtils.isEmpty(set)) {
            return null;
        }
        if (OsUtils.isUNIX() && (object = IoUtils.validateExcludedPermissions(set, STRICTLY_PROHIBITED_FILE_PERMISSION)) != null) {
            return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Permissions violation (%s)", object), (PosixFilePermission)((Object)object));
        }
        object = IoUtils.getFileOwner(path, linkOptionArray);
        if (GenericUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        String string = OsUtils.getCurrentUser();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        if (OsUtils.isUNIX()) {
            hashSet.add("root");
        }
        if (!hashSet.contains(object)) {
            return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Owner violation (%s)", object), (PosixFilePermission)((Object)object));
        }
        return null;
    }
}

