/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;

public final class IoUtils {
    public static final OpenOption[] EMPTY_OPEN_OPTIONS = new OpenOption[0];
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];
    public static final FileAttribute[] EMPTY_FILE_ATTRIBUTES = new FileAttribute[0];
    public static final List WINDOWS_EXECUTABLE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".bat", ".exe", ".cmd"));
    public static final String REGFILE_VIEW_ATTR = "isRegularFile";
    public static final String DIRECTORY_VIEW_ATTR = "isDirectory";
    public static final String SYMLINK_VIEW_ATTR = "isSymbolicLink";
    public static final String NUMLINKS_VIEW_ATTR = "nlink";
    public static final String OTHERFILE_VIEW_ATTR = "isOther";
    public static final String EXECUTABLE_VIEW_ATTR = "isExecutable";
    public static final String SIZE_VIEW_ATTR = "size";
    public static final String OWNER_VIEW_ATTR = "owner";
    public static final String GROUP_VIEW_ATTR = "group";
    public static final String USERID_VIEW_ATTR = "uid";
    public static final String GROUPID_VIEW_ATTR = "gid";
    public static final String PERMISSIONS_VIEW_ATTR = "permissions";
    public static final String ACL_VIEW_ATTR = "acl";
    public static final String FILEKEY_VIEW_ATTR = "fileKey";
    public static final String CREATE_TIME_VIEW_ATTR = "creationTime";
    public static final String LASTMOD_TIME_VIEW_ATTR = "lastModifiedTime";
    public static final String LASTACC_TIME_VIEW_ATTR = "lastAccessTime";
    public static final String EXTENDED_VIEW_ATTR = "extended";
    public static final int DEFAULT_COPY_SIZE = 8192;
    public static final String EOL = System.lineSeparator();
    public static final Set WRITEABLE_OPEN_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.APPEND, new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.CREATE_NEW, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.DSYNC, StandardOpenOption.SYNC, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE}));
    private static final byte[] EOL_BYTES = EOL.getBytes(StandardCharsets.UTF_8);
    private static final LinkOption[] NO_FOLLOW_OPTIONS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    private IoUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static byte[] getEOLBytes() {
        return (byte[])EOL_BYTES.clone();
    }

    public static LinkOption[] getLinkOptions(boolean bl2) {
        if (bl2) {
            return EMPTY_LINK_OPTIONS;
        }
        return (LinkOption[])NO_FOLLOW_OPTIONS.clone();
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) {
        return IoUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) {
        long l2 = 0L;
        byte[] byArray = new byte[n2];
        int n3 = inputStream.read(byArray);
        while (n3 > 0) {
            outputStream.write(byArray, 0, n3);
            l2 += (long)n3;
            n3 = inputStream.read(byArray);
        }
        return l2;
    }

    public static IOException closeQuietly(Closeable ... closeableArray) {
        return IoUtils.closeQuietly(GenericUtils.isEmpty(closeableArray) ? Collections.emptyList() : Arrays.asList(closeableArray));
    }

    public static IOException closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                return iOException;
            }
        }
        return null;
    }

    public static IOException closeQuietly(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return null;
        }
        IOException iOException = null;
        for (Closeable closeable : collection) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException2) {
                iOException = (IOException)ExceptionUtils.accumulateException(iOException, iOException2);
            }
        }
        return iOException;
    }

    public static boolean isWindowsExecutable(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        for (String string2 : WINDOWS_EXECUTABLE_EXTENSIONS) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static Set getPermissions(Path path, LinkOption ... linkOptionArray) {
        FileSystem fileSystem = path.getFileSystem();
        Set<String> set = fileSystem.supportedFileAttributeViews();
        if (set.contains("posix")) {
            return Files.getPosixFilePermissions(path, linkOptionArray);
        }
        return IoUtils.getPermissionsFromFile(path.toFile());
    }

    public static Set getPermissionsFromFile(File file) {
        EnumSet<PosixFilePermission> enumSet = EnumSet.noneOf(PosixFilePermission.class);
        if (file.canRead()) {
            enumSet.add(PosixFilePermission.OWNER_READ);
            enumSet.add(PosixFilePermission.GROUP_READ);
            enumSet.add(PosixFilePermission.OTHERS_READ);
        }
        if (file.canWrite()) {
            enumSet.add(PosixFilePermission.OWNER_WRITE);
            enumSet.add(PosixFilePermission.GROUP_WRITE);
            enumSet.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (IoUtils.isExecutable(file)) {
            enumSet.add(PosixFilePermission.OWNER_EXECUTE);
            enumSet.add(PosixFilePermission.GROUP_EXECUTE);
            enumSet.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return enumSet;
    }

    public static boolean isExecutable(File file) {
        if (file == null) {
            return false;
        }
        if (OsUtils.isWin32()) {
            return IoUtils.isWindowsExecutable(file.getName());
        }
        return file.canExecute();
    }

    public static void setPermissions(Path path, Set set) {
        FileSystem fileSystem = path.getFileSystem();
        Set<String> set2 = fileSystem.supportedFileAttributeViews();
        if (set2.contains("posix")) {
            Files.setPosixFilePermissions(path, set);
        } else {
            IoUtils.setPermissionsToFile(path.toFile(), set);
        }
    }

    public static void setPermissionsToFile(File file, Collection collection) {
        boolean bl2 = GenericUtils.isNotEmpty(collection);
        boolean bl3 = bl2 && (collection.contains((Object)PosixFilePermission.OWNER_READ) || collection.contains((Object)PosixFilePermission.GROUP_READ) || collection.contains((Object)PosixFilePermission.OTHERS_READ));
        file.setReadable(bl3, false);
        boolean bl4 = bl2 && (collection.contains((Object)PosixFilePermission.OWNER_WRITE) || collection.contains((Object)PosixFilePermission.GROUP_WRITE) || collection.contains((Object)PosixFilePermission.OTHERS_WRITE));
        file.setWritable(bl4, false);
        boolean bl5 = bl2 && (collection.contains((Object)PosixFilePermission.OWNER_EXECUTE) || collection.contains((Object)PosixFilePermission.GROUP_EXECUTE) || collection.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        file.setExecutable(bl5, false);
    }

    public static String getFileOwner(Path path, LinkOption ... linkOptionArray) {
        try {
            UserPrincipal userPrincipal = Files.getOwner(path, linkOptionArray);
            String string = userPrincipal == null ? null : userPrincipal.getName();
            return OsUtils.getCanonicalUser(string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    public static Boolean checkFileExists(Path path, LinkOption ... linkOptionArray) {
        boolean bl2 = IoUtils.followLinks(linkOptionArray);
        try {
            if (bl2) {
                path.getFileSystem().provider().checkAccess(path, new AccessMode[0]);
            } else {
                Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray);
            }
            return Boolean.TRUE;
        }
        catch (NoSuchFileException noSuchFileException) {
            return Boolean.FALSE;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Boolean checkFileExistsAnySymlinks(Path path, boolean bl2) {
        try {
            if (!bl2) {
                path.getFileSystem().provider().checkAccess(path, new AccessMode[0]);
            } else {
                for (int i2 = 1; i2 <= path.getNameCount(); ++i2) {
                    Path path2 = IoUtils.getFirstPartsOfPath(path, i2);
                    BasicFileAttributes basicFileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    if (!basicFileAttributes.isSymbolicLink()) continue;
                    return false;
                }
            }
            return true;
        }
        catch (NoSuchFileException noSuchFileException) {
            return false;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Path getFirstPartsOfPath(Path path, int n2) {
        String string = path.getName(0).toString();
        String[] stringArray = new String[n2 - 1];
        for (int i2 = 1; i2 < n2; ++i2) {
            stringArray[i2 - 1] = path.getName(i2).toString();
        }
        Path path2 = path.getFileSystem().getPath(string, stringArray);
        Path path3 = path.getRoot();
        if (path3 != null) {
            path2 = path3.resolve(path2);
        }
        return path2;
    }

    public static void readFully(InputStream inputStream, byte[] byArray) {
        IoUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4 = IoUtils.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Premature EOF - expected=" + n3 + ", actual=" + n4);
        }
    }

    public static int read(InputStream inputStream, byte[] byArray) {
        return IoUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        while (n4 > 0) {
            int n6 = inputStream.read(byArray, n5, n4);
            if (n6 == -1) {
                return n5 - n2;
            }
            n4 -= n6;
            n5 += n6;
        }
        return n3;
    }

    public static PosixFilePermission validateExcludedPermissions(Collection collection, Collection collection2) {
        if (GenericUtils.isEmpty(collection) || GenericUtils.isEmpty(collection2)) {
            return null;
        }
        for (PosixFilePermission posixFilePermission : collection2) {
            if (!collection.contains((Object)posixFilePermission)) continue;
            return posixFilePermission;
        }
        return null;
    }

    public static Path ensureDirectory(Path path, LinkOption ... linkOptionArray) {
        if (!Files.isDirectory(path, linkOptionArray)) {
            throw new UnsupportedOperationException("Not a directory: " + path);
        }
        return path;
    }

    public static boolean followLinks(LinkOption ... linkOptionArray) {
        if (GenericUtils.isEmpty(linkOptionArray)) {
            return true;
        }
        for (LinkOption linkOption : linkOptionArray) {
            if (linkOption != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    public static String appendPathComponent(String string, String string2) {
        if (GenericUtils.isEmpty(string)) {
            return string2;
        }
        if (GenericUtils.isEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + File.separator.length()).append(string);
        if (stringBuilder.charAt(string.length() - 1) == File.separatorChar) {
            if (string2.charAt(0) == File.separatorChar) {
                stringBuilder.append(string2.substring(1));
            } else {
                stringBuilder.append(string2);
            }
        } else {
            if (string2.charAt(0) != File.separatorChar) {
                stringBuilder.append(File.separatorChar);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static byte[] toByteArray(InputStream inputStream) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);){
            IoUtils.copy(inputStream, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static List readAllLines(URL uRL) {
        try (InputStream inputStream = Objects.requireNonNull(uRL, "No URL").openStream();){
            List list = IoUtils.readAllLines(inputStream);
            return list;
        }
    }

    public static List readAllLines(InputStream inputStream) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream, "No stream instance"), StandardCharsets.UTF_8);){
            List list = IoUtils.readAllLines(inputStreamReader);
            return list;
        }
    }

    public static List readAllLines(Reader reader) {
        try (BufferedReader bufferedReader = new BufferedReader(Objects.requireNonNull(reader, "No reader instance"), 8192);){
            List list = IoUtils.readAllLines(bufferedReader);
            return list;
        }
    }

    public static List readAllLines(BufferedReader bufferedReader) {
        return IoUtils.readAllLines(bufferedReader, -1);
    }

    public static List readAllLines(BufferedReader bufferedReader, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(Math.max(n2, 16));
        String string = bufferedReader.readLine();
        while (string != null) {
            arrayList.add(string);
            string = bufferedReader.readLine();
        }
        return arrayList;
    }

    public static Path chroot(Path path, Path path2) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(path2);
        List list = IoUtils.removeExtraCdUps(path2);
        return IoUtils.buildPath(path, path.getFileSystem(), list);
    }

    public static Path removeCdUpAboveRoot(Path path) {
        List list = IoUtils.removeExtraCdUps(path);
        return IoUtils.buildPath(path.getRoot(), path.getFileSystem(), list);
    }

    private static List removeExtraCdUps(Path path) {
        ArrayList<String> arrayList = new ArrayList<String>(path.getNameCount());
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < path.getNameCount(); ++i2) {
            String string = path.getName(i2).toString();
            if ("..".equals(string)) {
                if (n3 <= n2) continue;
                ++n2;
                arrayList.add(string);
                continue;
            }
            if (!".".equals(string)) {
                ++n3;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Path buildPath(Path path, FileSystem fileSystem, List list) {
        Objects.requireNonNull(fileSystem);
        if (list == null) {
            return null;
        }
        if (GenericUtils.isEmpty(list)) {
            return path == null ? fileSystem.getPath(".", new String[0]) : path;
        }
        Path path2 = IoUtils.buildRelativePath(fileSystem, list);
        return path == null ? path2 : path.resolve(path2);
    }

    public static Path buildRelativePath(FileSystem fileSystem, List list) {
        String[] stringArray = new String[list.size() - 1];
        Iterator iterator = list.iterator();
        String string = (String)iterator.next();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        Path path = fileSystem.getPath(string, stringArray);
        return path;
    }
}

