/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class FileSnapshot {
    public static final long UNKNOWN_SIZE = -1L;
    public static final FileSnapshot NO_FILE = new FileSnapshot(Instant.now(), null, -1L, null);
    private static final Duration WORST_CASE_TIMESTAMP_RESOLUTION = Duration.ofMillis(2000L);
    private final FileTime lastModified;
    private final long size;
    private final Object fileKey;
    private final Instant snapTime;

    protected FileSnapshot(Instant instant, FileTime fileTime, long l2, Object object) {
        this.snapTime = Objects.requireNonNull(instant);
        this.lastModified = fileTime;
        this.size = l2;
        this.fileKey = object;
    }

    protected FileTime getLastModified() {
        return this.lastModified;
    }

    protected long getSize() {
        return this.size;
    }

    protected Object getFileKey() {
        return this.fileKey;
    }

    protected Instant getTime() {
        return this.snapTime;
    }

    public static FileSnapshot save(Path path, LinkOption ... linkOptionArray) {
        BasicFileAttributes basicFileAttributes = null;
        Instant instant = Instant.now();
        try {
            basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray);
        }
        catch (NoSuchFileException noSuchFileException) {
            return NO_FILE;
        }
        if (basicFileAttributes == null) {
            return NO_FILE;
        }
        return new FileSnapshot(instant, basicFileAttributes.lastModifiedTime(), basicFileAttributes.size(), basicFileAttributes.fileKey());
    }

    public FileSnapshot reload(Path path, LinkOption ... linkOptionArray) {
        FileSnapshot fileSnapshot = FileSnapshot.save(path, linkOptionArray);
        if (fileSnapshot.mayBeRacilyClean()) {
            return fileSnapshot;
        }
        return this.same(fileSnapshot) && !this.mayBeRacilyClean() ? this : fileSnapshot;
    }

    protected boolean mayBeRacilyClean() {
        FileTime fileTime = this.getLastModified();
        return fileTime != null && Duration.between(fileTime.toInstant(), this.getTime()).compareTo(WORST_CASE_TIMESTAMP_RESOLUTION) <= 0;
    }

    public boolean same(FileSnapshot fileSnapshot) {
        if (this == fileSnapshot) {
            return true;
        }
        if (fileSnapshot == null) {
            return false;
        }
        return Objects.equals(this.getFileKey(), fileSnapshot.getFileKey()) && Objects.equals(this.getLastModified(), fileSnapshot.getLastModified()) && this.getSize() == fileSnapshot.getSize();
    }
}

