/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.sshd.common.util.io.IoUtils;

@FunctionalInterface
public interface FileInfoExtractor {
    public static final FileInfoExtractor EXISTS = Files::exists;
    public static final FileInfoExtractor ISDIR = Files::isDirectory;
    public static final FileInfoExtractor ISREG = Files::isRegularFile;
    public static final FileInfoExtractor ISSYMLINK = (path, linkOptionArray) -> Files.isSymbolicLink(path);
    public static final FileInfoExtractor SIZE = (path, linkOptionArray) -> Files.size(path);
    public static final FileInfoExtractor PERMISSIONS = IoUtils::getPermissions;
    public static final FileInfoExtractor LASTMODIFIED = Files::getLastModifiedTime;

    public Object infoOf(Path var1, LinkOption ... var2);
}

