/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.PathScanningMatcher;

public class DirectoryScanner
extends PathScanningMatcher {
    protected Path basedir;
    private boolean filesOnly = true;

    public DirectoryScanner() {
    }

    public DirectoryScanner(Path path) {
        this(path, Collections.emptyList());
    }

    public DirectoryScanner(Path path, String ... stringArray) {
        this(path, GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public DirectoryScanner(Path path, Collection collection) {
        this.setBasedir(path);
        this.setIncludes(collection);
    }

    public boolean isFilesOnly() {
        return this.filesOnly;
    }

    public void setFilesOnly(boolean bl2) {
        this.filesOnly = bl2;
    }

    public void setBasedir(Path path) {
        this.basedir = Objects.requireNonNull(path, "No base directory provided");
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Collection scan() {
        return this.scan(LinkedList::new);
    }

    public Collection scan(Supplier supplier) {
        String string;
        Path path = this.getBasedir();
        if (path == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalStateException("basedir " + path + " does not exist");
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalStateException("basedir " + path + " is not a directory");
        }
        if (GenericUtils.isEmpty(this.getIncludes())) {
            throw new IllegalStateException("No includes set for " + path);
        }
        FileSystem fileSystem = path.getFileSystem();
        String string2 = fileSystem.getSeparator();
        if (!Objects.equals(string2, string = this.getSeparator())) {
            throw new IllegalStateException("Mismatched separator - expected=" + string + ", actual=" + string2);
        }
        return this.scandir(path, path, (Collection)supplier.get());
    }

    protected Collection scandir(Path path, Path path2, Collection collection) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
            for (Path path3 : directoryStream) {
                Path path4 = path.relativize(path3);
                String string = path4.toString();
                if (Files.isDirectory(path3, new LinkOption[0])) {
                    if (this.isIncluded(string)) {
                        collection.add(path3);
                        this.scandir(path, path3, collection);
                        continue;
                    }
                    if (!this.couldHoldIncluded(string)) continue;
                    this.scandir(path, path3, collection);
                    continue;
                }
                if (this.filesOnly && !Files.isRegularFile(path3, new LinkOption[0]) || !this.isIncluded(string)) continue;
                collection.add(path3);
            }
        }
        return collection;
    }
}

