/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;

public class LazyMatchingTypeIterator
implements Iterator {
    protected boolean finished;
    protected Object nextValue;
    private final Iterator values;
    private final Class type;

    public LazyMatchingTypeIterator(Iterator iterator, Class clazz) {
        this.values = iterator;
        this.type = Objects.requireNonNull(clazz, "No type selector specified");
    }

    public Iterator getValues() {
        return this.values;
    }

    public Class getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        this.nextValue = GenericUtils.selectNextMatchingValue(this.getValues(), this.getType());
        if (this.nextValue == null) {
            this.finished = true;
        }
        return !this.finished;
    }

    public Object next() {
        if (this.finished) {
            throw new NoSuchElementException("All values have been exhausted");
        }
        if (this.nextValue == null) {
            throw new IllegalStateException("'next()' called without asking 'hasNext()'");
        }
        Object object = this.nextValue;
        this.nextValue = null;
        return object;
    }

    public String toString() {
        Class clazz = this.getType();
        return Iterator.class.getSimpleName() + "[lazy-select](" + clazz.getSimpleName() + ")";
    }

    public static Iterator lazySelectMatchingTypes(Iterator iterator, Class clazz) {
        Objects.requireNonNull(clazz, "No type selector specified");
        return iterator == null ? Collections.emptyIterator() : new LazyMatchingTypeIterator(iterator, clazz);
    }
}

