/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sshd.common.util.helper.LazyMatchingTypeIterator;

public class LazyMatchingTypeIterable
implements Iterable {
    private final Iterable values;
    private final Class type;

    public LazyMatchingTypeIterable(Iterable iterable, Class clazz) {
        this.values = iterable;
        this.type = Objects.requireNonNull(clazz, "No type selector specified");
    }

    public Iterable getValues() {
        return this.values;
    }

    public Class getType() {
        return this.type;
    }

    public Iterator iterator() {
        Iterable iterable = this.getValues();
        if (iterable == null) {
            return Collections.emptyIterator();
        }
        return LazyMatchingTypeIterator.lazySelectMatchingTypes(iterable.iterator(), this.getType());
    }

    public String toString() {
        Class clazz = this.getType();
        return Iterable.class.getSimpleName() + "[lazy-select](" + clazz.getSimpleName() + ")";
    }

    public static Iterable lazySelectMatchingTypes(Iterable iterable, Class clazz) {
        Objects.requireNonNull(clazz, "No type selector specified");
        return iterable == null ? Collections.emptyList() : new LazyMatchingTypeIterable(iterable, clazz);
    }
}

