/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.functors;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface UnaryEquator
extends BiPredicate {
    default public UnaryEquator and(UnaryEquator unaryEquator) {
        Objects.requireNonNull(unaryEquator, "No other equator to compose");
        return (object, object2) -> this.test(object, object2) && unaryEquator.test(object, object2);
    }

    default public UnaryEquator or(UnaryEquator unaryEquator) {
        Objects.requireNonNull(unaryEquator, "No other equator to compose");
        return (object, object2) -> this.test(object, object2) || unaryEquator.test(object, object2);
    }

    default public UnaryEquator negate() {
        return (object, object2) -> !this.test(object, object2);
    }

    public static boolean isSameReference(Object object, Object object2) {
        return object == object2;
    }

    public static UnaryEquator defaultEquality() {
        return Objects::equals;
    }

    public static UnaryEquator referenceEquality() {
        return UnaryEquator::isSameReference;
    }

    public static UnaryEquator comparing(Comparator comparator) {
        Objects.requireNonNull(comparator, "No comparator");
        return (object, object2) -> comparator.compare(object, object2) == 0;
    }

    public static UnaryEquator verum() {
        return (object, object2) -> true;
    }

    public static UnaryEquator falsum() {
        return (object, object2) -> false;
    }
}

