/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.functors;

import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.util.ValidateUtils;

public final class Int2IntFunction {
    private Int2IntFunction() {
        throw new UnsupportedOperationException("No instance");
    }

    public static IntUnaryOperator sub(int n2) {
        return Int2IntFunction.add(0 - n2);
    }

    public static IntUnaryOperator add(int n2) {
        if (n2 == 0) {
            return IntUnaryOperator.identity();
        }
        return n3 -> n3 + n2;
    }

    public static IntUnaryOperator mul(int n2) {
        if (n2 == 0) {
            return Int2IntFunction.constant(0);
        }
        if (n2 == 1) {
            return IntUnaryOperator.identity();
        }
        return n3 -> n3 * n2;
    }

    public static IntUnaryOperator constant(int n2) {
        return n3 -> n2;
    }

    public static IntUnaryOperator div(int n2) {
        if (n2 == 1) {
            return IntUnaryOperator.identity();
        }
        ValidateUtils.checkTrue(n2 != 0, "Zero division factor");
        return n3 -> n3 / n2;
    }
}

