/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public class ParallelCloseable
extends SimpleCloseable {
    private final Iterable closeables;

    public ParallelCloseable(Object object, Object object2, Iterable iterable) {
        super(object, object2);
        this.closeables = iterable == null ? Collections.emptyList() : iterable;
    }

    @Override
    protected void doClose(boolean bl2) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        boolean bl3 = this.log.isTraceEnabled();
        SshFutureListener sshFutureListener = closeFuture -> {
            int n2 = atomicInteger.decrementAndGet();
            if (bl3) {
                this.log.trace("doClose({}) completed pending: {}", (Object)bl2, (Object)n2);
            }
            if (n2 == 0) {
                this.future.setClosed();
            }
        };
        for (Closeable closeable : this.closeables) {
            if (closeable == null) continue;
            int n2 = atomicInteger.incrementAndGet();
            if (bl3) {
                this.log.trace("doClose({}) pending closeables: {}", (Object)bl2, (Object)n2);
            }
            closeable.close(bl2).addListener(sshFutureListener);
        }
        sshFutureListener.operationComplete(null);
    }
}

