/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.Channel;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ProxyUtils;
import org.apache.sshd.common.util.closeable.AutoCloseableDelegateInvocationHandler;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioChannelDelegateInvocationHandler
extends AutoCloseableDelegateInvocationHandler {
    public NioChannelDelegateInvocationHandler(Object object, Channel channel) {
        super(object, channel);
    }

    public Channel getChannelDelegate() {
        return (Channel)Channel.class.cast(super.getAutoCloseableDelegate());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (!NioChannelDelegateInvocationHandler.isQueryOpenMethodInvocation(method, objectArray)) {
            return super.invoke(object, method, objectArray);
        }
        Channel channel = this.getChannelDelegate();
        try {
            return method.invoke((Object)channel, objectArray);
        }
        catch (Throwable throwable) {
            Class<?> clazz = channel.getClass();
            Logger logger = LoggerFactory.getLogger(clazz);
            LoggingUtils.debug(logger, "invoke({}#{}) failed ({}) to execute: {}", clazz.getSimpleName(), method.getName(), throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            throw ProxyUtils.unwrapInvocationThrowable(throwable);
        }
    }

    public static Channel wrapDelegateChannel(Object object, Class clazz, Channel channel) {
        return (Channel)ProxyUtils.newProxyInstance(clazz, new NioChannelDelegateInvocationHandler(object, channel));
    }

    public static boolean isQueryOpenMethodInvocation(Method method, Object[] objectArray) {
        return NioChannelDelegateInvocationHandler.isQueryOpenMethodInvocation(method) && GenericUtils.isEmpty(objectArray);
    }

    public static boolean isQueryOpenMethodInvocation(Method method) {
        int n2 = method == null ? 0 : method.getModifiers();
        return method != null && "isOpen".equals(method.getName()) && Modifier.isPublic(n2) && !Modifier.isStatic(n2) && Boolean.TYPE == method.getReturnType() && GenericUtils.isEmpty(method.getParameterTypes());
    }
}

