/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public class FuturesCloseable
extends SimpleCloseable {
    private final Iterable futures;

    public FuturesCloseable(Object object, Object object2, Iterable iterable) {
        super(object, object2);
        this.futures = iterable == null ? Collections.emptyList() : iterable;
    }

    @Override
    protected void doClose(boolean bl2) {
        if (bl2) {
            for (SshFuture sshFuture2 : this.futures) {
                if (!(sshFuture2 instanceof DefaultSshFuture)) continue;
                ((DefaultSshFuture)sshFuture2).setValue(new SshException("Closed"));
            }
            this.future.setClosed();
        } else {
            AtomicInteger atomicInteger = new AtomicInteger(1);
            boolean bl3 = this.log.isTraceEnabled();
            SshFutureListener sshFutureListener = sshFuture -> {
                int n2 = atomicInteger.decrementAndGet();
                if (bl3) {
                    this.log.trace("doClose({}) complete pending: {}", (Object)bl2, (Object)n2);
                }
                if (n2 == 0) {
                    this.future.setClosed();
                }
            };
            for (SshFuture sshFuture3 : this.futures) {
                if (sshFuture3 == null) continue;
                int n2 = atomicInteger.incrementAndGet();
                if (bl3) {
                    this.log.trace("doClose({}) future pending: {}", (Object)bl2, (Object)n2);
                }
                sshFuture3.addListener(sshFutureListener);
            }
            sshFutureListener.operationComplete(null);
        }
    }
}

