/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.closeable.Builder$1;
import org.apache.sshd.common.util.closeable.FuturesCloseable;
import org.apache.sshd.common.util.closeable.ParallelCloseable;
import org.apache.sshd.common.util.closeable.SequentialCloseable;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public final class Builder
implements ObjectBuilder {
    private final Object lock;
    private final List closeables = new ArrayList();

    public Builder(Object object) {
        this.lock = Objects.requireNonNull(object, "No lock");
    }

    public Builder run(Object object, Runnable runnable) {
        return this.close(new Builder$1(this, object, this.lock, runnable));
    }

    public Builder when(SshFuture sshFuture) {
        if (sshFuture != null) {
            this.when(sshFuture.getId(), Collections.singleton(sshFuture));
        }
        return this;
    }

    @SafeVarargs
    public final Builder when(SshFuture ... sshFutureArray) {
        return this.when(this.getClass().getSimpleName(), Arrays.asList(sshFutureArray));
    }

    public Builder when(Object object, Iterable iterable) {
        return this.close(new FuturesCloseable(object, this.lock, iterable));
    }

    public Builder sequential(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            this.close(closeable);
        }
        return this;
    }

    public Builder sequential(Object object, Iterable iterable) {
        return this.close(new SequentialCloseable(object, this.lock, iterable));
    }

    public Builder parallel(Closeable ... closeableArray) {
        if (closeableArray.length == 1) {
            this.close(closeableArray[0]);
        } else if (closeableArray.length > 0) {
            this.parallel(this.getClass().getSimpleName(), Arrays.asList(closeableArray));
        }
        return this;
    }

    public Builder parallel(Object object, Iterable iterable) {
        return this.close(new ParallelCloseable(object, this.lock, iterable));
    }

    public Builder close(Closeable closeable) {
        if (closeable != null) {
            this.closeables.add(closeable);
        }
        return this;
    }

    @Override
    public Closeable build() {
        if (this.closeables.isEmpty()) {
            return new SimpleCloseable(this.getClass().getSimpleName(), this.lock);
        }
        if (this.closeables.size() == 1) {
            return (Closeable)this.closeables.get(0);
        }
        return new SequentialCloseable(this.getClass().getSimpleName(), this.lock, this.closeables);
    }
}

